﻿Imports System.IO

Imports QCAP.NET

Public Class Form1

    Public Declare Function FindWindow Lib "user32" Alias "FindWindowA" (ByVal lpClassName As String, ByVal lpWindowName As String) As UInt32

    Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hWnd As UInt32, ByVal wMsg As UInt32, ByVal wParam As UInt32, ByVal lParam As UInt32) As UInt32

    Declare Function PostMessage Lib "user32" Alias "PostMessageA" (ByVal hWnd As UInt32, ByVal wMsg As UInt32, ByVal wParam As UInt32, ByVal lParam As UInt32) As UInt32

    Declare Function OutputDebugString Lib "kernel32" Alias "OutputDebugStringA" (ByVal message As String)

    Public m_bIsMaximizedForm As Boolean = False

    Public m_bIsMaximizedChannelWindow() As Boolean = {False, False, False, False}

    Public m_bNoSignal() As Boolean = {True, True, True, True}

    Public m_strFormatChangedOutput() As String = {"", "", "", ""}

    Public m_bShareRecordCH() As Boolean = {False, False, False, False}

    Public m_bShowClone As Boolean = False

    Public m_bIsShareRecord As Boolean = False

    Public m_nVideoWidth As UInt32 = 1920

    Public m_nVideoHeight As UInt32 = 1080

    Public m_dVideoFrameRate As Double = 60.0

    Public m_bIsStreaming As Boolean = False

    Public m_hRtspCapDev As UInt32 = 0 ' RTSP STREAM CAPTURE DEVICE

    ' CALLBACK FUNCTION
    '
    Public m_pFormatChangedCB As EXPORTS.PF_FORMAT_CHANGED_CALLBACK = Nothing

    Public m_pNoSignalDetectedCB As EXPORTS.PF_NO_SIGNAL_DETECTED_CALLBACK = Nothing

    Public m_pSignalRemovedCB As EXPORTS.PF_SIGNAL_REMOVED_CALLBACK = Nothing

    Public m_pPreviewVideoCB As EXPORTS.PF_VIDEO_PREVIEW_CALLBACK = Nothing

    Public m_pPreviewAudioCB As EXPORTS.PF_AUDIO_PREVIEW_CALLBACK = Nothing

    Public m_pVideoHardwareEncoderCB As EXPORTS.PF_VIDEO_HARDWARE_ENCODER_CALLBACK = Nothing

    Public m_pChannelControl_LIVE(0 To 3) As MyChannelControl

    Public m_cSetupControl As MySetupControl

    Public m_strChipName As String = "FH8735 PCI"

    ' DEVICE PROPERTY
    '
    Public m_hCapDev() As UInt32 = {0, 0, 0, 0} ' STREAM CAPTURE DEVICE

    Public m_hCloneCapDev() As UInt32 = {0, 0, 0, 0} ' CLONE STREAM CAPTURE DEVICE

    ' FORMAT CHANGED CALLBACK FUNCTION
    '
    Public Function on_process_format_changed(ByVal pDevice As UInt32, ByVal nVideoInput As UInt32, ByVal nAudioInput As UInt32, ByVal nVideoWidth As UInt32, ByVal nVideoHeight As UInt32, ByVal bVideoIsInterleaved As UInt32, ByVal dVideoFrameRate As Double, ByVal nAudioChannels As UInt32, ByVal nAudioBitsPerSample As UInt32, ByVal nAudioSampleFrequency As UInt32, ByVal pUserData As UInt32) As EXPORTS.ReturnOfCallbackEnum

        Dim nCH As UInt32 = pUserData

        ' OUTPUT FORMAT CHANGED MESSAGE
        '
        'Dim strOutput As String = "CH" + (nCH + 1).ToString() + " -> FORMAT CHANGED : pDevice : " + pDevice.ToString() + " , " + "nVideoInput : " + nVideoInput.ToString() + " , " + "nAudioInput : " + nAudioInput.ToString() + " , " + "nVideoWidth : " + nVideoWidth.ToString() + " , " + "nVideoHeight : " + nVideoHeight.ToString() + " , " + "bVideoIsInterleaved : " + bVideoIsInterleaved.ToString() + " , " + "dVideoFrameRate : " + dVideoFrameRate.ToString() + " , " + "nAudioChannels : " + nAudioChannels.ToString() + " , " + "nAudioBitsPerSample : " + nAudioBitsPerSample.ToString() + " , " + "nAudioSampleFrequency : " + nAudioSampleFrequency.ToString() + " , " + "pUserData : " + pUserData.ToString() + " \n"

        'OutputDebugString(strOutput)

        m_nVideoWidth = nVideoWidth

        m_nVideoHeight = nVideoHeight

        m_dVideoFrameRate = dVideoFrameRate

        Dim nVH As UInt32 = 0

        Dim strFrameType As String = " P "

        Dim strVideoInput As String = ""

        Dim strAudioInput As String = ""

        If nVideoInput = 0 Then : strVideoInput = "COMPOSITE" : End If

        If nVideoInput = 1 Then : strVideoInput = "SVIDEO" : End If

        If nVideoInput = 2 Then : strVideoInput = "HDMI" : End If

        If nVideoInput = 3 Then : strVideoInput = "DVI_D" : End If

        If nVideoInput = 4 Then : strVideoInput = "COMPONENTS (YCBCR)" : End If

        If nVideoInput = 5 Then : strVideoInput = "DVI_A (RGB / VGA)" : End If

        If nVideoInput = 6 Then : strVideoInput = "SDI" : End If

        If nVideoInput = 7 Then : strVideoInput = "AUTO" : End If

        If nAudioInput = 0 Then : strAudioInput = "EMBEDDED_AUDIO" : End If

        If nAudioInput = 1 Then : strAudioInput = "LINE_IN" : End If

        If bVideoIsInterleaved = 1 Then : nVH = nVideoHeight / 2 : Else : nVH = nVideoHeight : End If

        If bVideoIsInterleaved = 1 Then : strFrameType = " I " : Else : strFrameType = " P " : End If

        m_strFormatChangedOutput(nCH) = " INFO : " + nVideoWidth.ToString() + " x " + nVH.ToString() + strFrameType + " @" + dVideoFrameRate.ToString() + " FPS , " + nAudioChannels.ToString() + " CH x " + nAudioBitsPerSample.ToString() + " BITS x " + nAudioSampleFrequency.ToString() + " HZ , " + " VIDEO INPUT : " + strVideoInput + " , " + " AUDIO INPUT : " + strAudioInput + " \n"

        ' NO SIGNAL
        '    
        If nVideoWidth = 0 And nVideoHeight = 0 And dVideoFrameRate = 0.0 And nAudioChannels = 0 And nAudioBitsPerSample = 0 And nAudioSampleFrequency = 0 Then

            m_bNoSignal(nCH) = True

        Else

            m_bNoSignal(nCH) = False

        End If

        Return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK

    End Function

    ' PREVIEW VIDEO CALLBACK FUNCTION
    '
    Public Function on_process_preview_video_buffer(ByVal pDevice As UInt32, ByVal dSampleTime As Double, ByVal pFrameBuffer As UInt32, ByVal nFrameBufferLen As UInt32, ByVal pUserData As UInt32) As EXPORTS.ReturnOfCallbackEnum

        Dim nCH As UInt32 = pUserData

        ' string strOutput = "CH" + (nCH + 1).ToString() +  " : on_process_preview_video_buffer => pDevice : " + pDevice.ToString() + " , dSampleTime : " + dSampleTime.ToString() + " , pFrameBuffer : " + pFrameBuffer.ToString() + " , nFrameBufferLen : " + nFrameBufferLen.ToString() + " , pUserData : " + pUserData.ToString() + " \n"

        ' OutputDebugString(strOutput);

        If m_bIsShareRecord = True And m_bShareRecordCH(nCH) = True Then

            EXPORTS.QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER(0, &H32315659, m_nVideoWidth, m_nVideoHeight, pFrameBuffer, nFrameBufferLen)

        End If

        If m_bIsStreaming = True And m_hRtspCapDev <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(m_hRtspCapDev, nCH, EXPORTS.ColorSpaceTypeEnum.QCAP_COLORSPACE_TYEP_YV12, m_nVideoWidth, m_nVideoHeight, pFrameBuffer, nFrameBufferLen)

        End If

        Return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK

    End Function

    ' PREVIEW AUDIO CALLBACK FUNCTION
    '
    Public Function on_process_preview_audio_buffer(ByVal pDevice As UInt32, ByVal dSampleTime As Double, ByVal pFrameBuffer As UInt32, ByVal nFrameBufferLen As UInt32, ByVal pUserData As UInt32) As EXPORTS.ReturnOfCallbackEnum

        Dim nCH As UInt32 = pUserData

        ' string strOutput = "CH" + (nCH + 1).ToString() + " : on_process_preview_audio_buffer => pDevice : " + pDevice.ToString() + " , dSampleTime : " + dSampleTime.ToString() + " , pFrameBuffer : " + pFrameBuffer.ToString() + " , nFrameBufferLen : " + nFrameBufferLen.ToString() + " , pUserData : " + pUserData.ToString() + " \n

        'OutputDebugString(strOutput)

        If m_bIsShareRecord = True And m_bShareRecordCH(nCH) = True Then

            EXPORTS.QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER(0, pFrameBuffer, nFrameBufferLen)

        End If

        If m_bIsStreaming = True And m_hRtspCapDev <> 0 Then

            EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(m_hRtspCapDev, nCH, pFrameBuffer, nFrameBufferLen)

        End If

        Return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK

    End Function

    ' NO SIGNAL DETEACTED CALLBACK FUNCTION
    '
    Public Function on_process_no_signal_detected(ByVal pDevice As UInt32, ByVal nVideoInput As UInt32, ByVal nAudioInput As UInt32, ByVal pUserData As UInt32) As EXPORTS.ReturnOfCallbackEnum

        Dim nCH As UInt32 = pUserData

        'OutputDebugString("CH" + (nCH + 1).ToString() + " No Signal Detected  \n")

        m_bNoSignal(nCH) = True

        Return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK

    End Function

    ' SIGNAL REMOVED CALLBACK FUNCTION
    '
    Public Function on_process_signal_removed(ByVal pDevice As UInt32, ByVal nVideoInput As UInt32, ByVal nAudioInput As UInt32, ByVal pUserData As UInt32) As EXPORTS.ReturnOfCallbackEnum

        Dim nCH As UInt32 = pUserData

        'OutputDebugString("CH" + (nCH + 1).ToString() + " Signal Removed \n")

        m_bNoSignal(nCH) = True

        Return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK

    End Function

    ' VIDEO HARDWARE ENCODER CALLBACK FUNCTION
    '
    Public Function on_process_hardware_encoder_video_buffer(ByVal pDevice As UInt32, ByVal iRecNum As Long, ByVal dSampleTime As Double, ByVal pStreamBuffer As UInt32, ByVal nStreamBufferLen As UInt32, ByVal bIsKeyFrame As UInt32, ByVal pUserData As UInt32) As EXPORTS.ReturnOfCallbackEnum

        Dim nCH As UInt32 = pUserData

        Return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK

    End Function

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        Dim i As UInt32 = 0

        ' CREATE CHANNEL WINDOW
        '
        For i = 0 To 3

            m_pChannelControl_LIVE(i) = New MyChannelControl()

            m_pChannelControl_LIVE(i).Parent = Me

            ' LEFT POSITION
            '
            If i = 0 Then m_pChannelControl_LIVE(i).Left = 0

            If i = 1 Then m_pChannelControl_LIVE(i).Left = Me.Width / 2

            If i = 2 Then m_pChannelControl_LIVE(i).Left = 0

            If i = 3 Then m_pChannelControl_LIVE(i).Left = Me.Width / 2

            ' TOP POSITION
            '
            If i = 0 Then m_pChannelControl_LIVE(i).Top = 0

            If i = 1 Then m_pChannelControl_LIVE(i).Top = 0

            If i = 2 Then m_pChannelControl_LIVE(i).Top = Me.Height / 2

            If i = 3 Then m_pChannelControl_LIVE(i).Top = Me.Height / 2

            ' WIDTH & HEIGHT
            '
            m_pChannelControl_LIVE(i).Size = New System.Drawing.Size(Me.Width / 2, Me.Height / 2)

            m_pChannelControl_LIVE(i).Visible = True

            m_pChannelControl_LIVE(i).m_nChannelNumber = i + 1

            m_bIsMaximizedChannelWindow(i) = False

        Next

        CloneChannelPanel1.Left = 0 : CloneChannelPanel1.Top = 0 : CloneChannelPanel1.Width = 160 : CloneChannelPanel1.Height = 120 : CloneChannelPanel1.Visible = False

        CloneChannelPanel2.Left = Me.Width / 2 : CloneChannelPanel2.Top = 0 : CloneChannelPanel2.Width = 160 : CloneChannelPanel2.Height = 120 : CloneChannelPanel2.Visible = False

        CloneChannelPanel3.Left = 0 : CloneChannelPanel3.Top = Me.Height / 2 : CloneChannelPanel3.Width = 160 : CloneChannelPanel3.Height = 120 : CloneChannelPanel3.Visible = False

        CloneChannelPanel4.Left = Me.Width / 2 : CloneChannelPanel4.Top = Me.Height / 2 : CloneChannelPanel4.Width = 160 : CloneChannelPanel4.Height = 120 : CloneChannelPanel4.Visible = False

        HwInitialize()

        ' USER INTERFACE PROGRAMMING (SETUP CONTROL)
        '        
        m_cSetupControl = New MySetupControl()

        m_cSetupControl.m_pMainForm = Me

        ' Associate the code to be executed (event handler) with the event.
        '
        AddHandler m_cSetupControl.FormClosed, AddressOf Me.SetupControlClosed

        m_cSetupControl.Left = Me.Left

        m_cSetupControl.Top = Me.Bottom - 20

        m_cSetupControl.Visible = True

        m_cSetupControl.Show()

        m_bShareRecordCH(0) = True : m_bShareRecordCH(1) = False : m_bShareRecordCH(2) = False : m_bShareRecordCH(3) = False

    End Sub

    Private Sub Form1_FormClosed(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed

        timerCheckSignal.Enabled = False

        EXPORTS.QCAP_STOP_SHARE_RECORD(0)

        HwUnInitialize()

    End Sub

    Public Sub HwInitialize()

        Dim i As UInt32 = 0

        For i = 0 To 3 : m_hCapDev(i) = 0 : Next

        For i = 0 To 3 : m_hCloneCapDev(i) = 0 : Next

        For i = 0 To 3 : m_bNoSignal(i) = True : Next

        For i = 0 To 3 : m_strFormatChangedOutput(i) = "" : Next

        ' CREATE CAPTURE DEVICE            
        '
        EXPORTS.QCAP_CREATE(m_strChipName, 0, m_pChannelControl_LIVE(0).Handle.ToInt32(), m_hCapDev(0), 1)

        EXPORTS.QCAP_CREATE(m_strChipName, 1, m_pChannelControl_LIVE(1).Handle.ToInt32(), m_hCapDev(1), 1)

        EXPORTS.QCAP_CREATE(m_strChipName, 2, m_pChannelControl_LIVE(2).Handle.ToInt32(), m_hCapDev(2), 1)

        EXPORTS.QCAP_CREATE(m_strChipName, 3, m_pChannelControl_LIVE(3).Handle.ToInt32(), m_hCapDev(3), 1)

        ' REGISTER FORMAT CHANGED CALLBACK FUNCTION
        ' 
        m_pFormatChangedCB = New EXPORTS.PF_FORMAT_CHANGED_CALLBACK(AddressOf on_process_format_changed)

        EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_hCapDev(0), m_pFormatChangedCB, 0)

        EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_hCapDev(1), m_pFormatChangedCB, 1)

        EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_hCapDev(2), m_pFormatChangedCB, 2)

        EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_hCapDev(3), m_pFormatChangedCB, 3)

        ' REGISTER PREVIEW VIDEO CALLBACK FUNCTION
        ' 
        m_pPreviewVideoCB = New EXPORTS.PF_VIDEO_PREVIEW_CALLBACK(AddressOf on_process_preview_video_buffer)

        EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_hCapDev(0), m_pPreviewVideoCB, 0)

        EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_hCapDev(1), m_pPreviewVideoCB, 1)

        EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_hCapDev(2), m_pPreviewVideoCB, 2)

        EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_hCapDev(3), m_pPreviewVideoCB, 3)

        ' REGISTER PREVIEW AUDIO CALLBACK FUNCTION
        '
        m_pPreviewAudioCB = New EXPORTS.PF_AUDIO_PREVIEW_CALLBACK(AddressOf on_process_preview_audio_buffer)

        EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_hCapDev(0), m_pPreviewAudioCB, 0)

        EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_hCapDev(1), m_pPreviewAudioCB, 1)

        EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_hCapDev(2), m_pPreviewAudioCB, 2)

        EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_hCapDev(3), m_pPreviewAudioCB, 3)

        ' REGISTER NO SIGNAL DETECTED CALLBACK FUNCTION
        '
        m_pNoSignalDetectedCB = New EXPORTS.PF_NO_SIGNAL_DETECTED_CALLBACK(AddressOf on_process_no_signal_detected)

        EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_hCapDev(0), m_pNoSignalDetectedCB, 0)

        EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_hCapDev(1), m_pNoSignalDetectedCB, 1)

        EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_hCapDev(2), m_pNoSignalDetectedCB, 2)

        EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_hCapDev(3), m_pNoSignalDetectedCB, 3)

        ' REGISTER SIGNAL REMOVED CALLBACK FUNCTION
        '
        m_pSignalRemovedCB = New EXPORTS.PF_SIGNAL_REMOVED_CALLBACK(AddressOf on_process_signal_removed)

        EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_hCapDev(0), m_pSignalRemovedCB, 0)

        EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_hCapDev(1), m_pSignalRemovedCB, 1)

        EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_hCapDev(2), m_pSignalRemovedCB, 2)

        EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_hCapDev(3), m_pSignalRemovedCB, 3)

        ' REGISTER VIDEO HARDWARE ENCODER CALLBACK FUNCTION
        '
        m_pVideoHardwareEncoderCB = New EXPORTS.PF_VIDEO_HARDWARE_ENCODER_CALLBACK(AddressOf on_process_hardware_encoder_video_buffer)

        EXPORTS.QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK(m_hCapDev(0), 1, m_pVideoHardwareEncoderCB, 0)

        EXPORTS.QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK(m_hCapDev(1), 1, m_pVideoHardwareEncoderCB, 1)

        EXPORTS.QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK(m_hCapDev(2), 1, m_pVideoHardwareEncoderCB, 2)

        EXPORTS.QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK(m_hCapDev(3), 1, m_pVideoHardwareEncoderCB, 3)

        ' SET INPUT
        '
        Dim nInput = EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_SDI

        EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev(0), nInput)

        EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev(1), nInput)

        EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev(2), nInput)

        EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev(3), nInput)

        ' RUN DEVICE
        '
        EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev(0), 0)

        EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev(1), 0)

        EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev(2), 0)

        EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev(3), 0)

        EXPORTS.QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX(m_hCapDev(0), 0, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_MAIN, EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_41, EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CABAC, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)

        EXPORTS.QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX(m_hCapDev(0), 1, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_MAIN, EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_41, EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CABAC, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)

        EXPORTS.QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX(m_hCapDev(1), 0, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_MAIN, EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_41, EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CABAC, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)

        EXPORTS.QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX(m_hCapDev(1), 1, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_MAIN, EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_41, EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CABAC, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)

        EXPORTS.QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX(m_hCapDev(2), 0, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_MAIN, EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_41, EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CABAC, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)

        EXPORTS.QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX(m_hCapDev(2), 1, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_MAIN, EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_41, EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CABAC, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)

        EXPORTS.QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX(m_hCapDev(3), 0, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_MAIN, EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_41, EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CABAC, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)

        EXPORTS.QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX(m_hCapDev(3), 1, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_MAIN, EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_41, EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CABAC, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)

        EXPORTS.QCAP_RUN(m_hCapDev(0))

        EXPORTS.QCAP_RUN(m_hCapDev(1))

        EXPORTS.QCAP_RUN(m_hCapDev(2))

        EXPORTS.QCAP_RUN(m_hCapDev(3))

        timerCheckSignal.Enabled = True

    End Sub

    Public Sub HwUnInitialize()

        EXPORTS.QCAP_DESTROY_BROADCAST_SERVER(m_hRtspCapDev)

        If m_hCloneCapDev(0) <> 0 Then : EXPORTS.QCAP_STOP(m_hCloneCapDev(0)) : EXPORTS.QCAP_DESTROY(m_hCloneCapDev(0)) : End If

        If m_hCloneCapDev(1) <> 0 Then : EXPORTS.QCAP_STOP(m_hCloneCapDev(1)) : EXPORTS.QCAP_DESTROY(m_hCloneCapDev(1)) : End If

        If m_hCloneCapDev(2) <> 0 Then : EXPORTS.QCAP_STOP(m_hCloneCapDev(2)) : EXPORTS.QCAP_DESTROY(m_hCloneCapDev(2)) : End If

        If m_hCloneCapDev(3) <> 0 Then : EXPORTS.QCAP_STOP(m_hCloneCapDev(3)) : EXPORTS.QCAP_DESTROY(m_hCloneCapDev(3)) : End If

        If m_hCapDev(0) <> 0 Then : EXPORTS.QCAP_STOP(m_hCapDev(0)) : EXPORTS.QCAP_DESTROY(m_hCapDev(0)) : End If

        If m_hCapDev(1) <> 0 Then : EXPORTS.QCAP_STOP(m_hCapDev(1)) : EXPORTS.QCAP_DESTROY(m_hCapDev(1)) : End If

        If m_hCapDev(2) <> 0 Then : EXPORTS.QCAP_STOP(m_hCapDev(2)) : EXPORTS.QCAP_DESTROY(m_hCapDev(2)) : End If

        If m_hCapDev(3) <> 0 Then : EXPORTS.QCAP_STOP(m_hCapDev(3)) : EXPORTS.QCAP_DESTROY(m_hCapDev(3)) : End If

    End Sub

    Public Sub ShowCloneVideo(ByVal bShow As Boolean)

        If bShow = True Then

            m_bShowClone = True

            If m_pChannelControl_LIVE(0).Visible = True Then

                CloneChannelPanel1.Visible = True

                If m_hCapDev(0) <> 0 Then

                    EXPORTS.QCAP_CREATE_CLONE(m_hCapDev(0), CloneChannelPanel1.Handle.ToInt32(), m_hCloneCapDev(0), 1)

                    If m_hCloneCapDev(0) <> 0 Then

                        EXPORTS.QCAP_RUN(m_hCloneCapDev(0))

                        EXPORTS.QCAP_SET_AUDIO_VOLUME(m_hCloneCapDev(0), 0)

                    End If

                End If

            End If

            If m_pChannelControl_LIVE(1).Visible = True Then

                CloneChannelPanel2.Visible = True

                If m_hCapDev(1) <> 0 Then

                    EXPORTS.QCAP_CREATE_CLONE(m_hCapDev(1), CloneChannelPanel2.Handle.ToInt32(), m_hCloneCapDev(1), 1)

                    If m_hCloneCapDev(1) <> 0 Then

                        EXPORTS.QCAP_RUN(m_hCloneCapDev(1))

                        EXPORTS.QCAP_SET_AUDIO_VOLUME(m_hCloneCapDev(1), 0)

                    End If

                End If

            End If

            If m_pChannelControl_LIVE(2).Visible = True Then

                CloneChannelPanel3.Visible = True

                If m_hCapDev(2) <> 0 Then

                    EXPORTS.QCAP_CREATE_CLONE(m_hCapDev(2), CloneChannelPanel3.Handle.ToInt32(), m_hCloneCapDev(2), 1)

                    If m_hCloneCapDev(2) <> 0 Then

                        EXPORTS.QCAP_RUN(m_hCloneCapDev(2))

                        EXPORTS.QCAP_SET_AUDIO_VOLUME(m_hCloneCapDev(2), 0)

                    End If

                End If

            End If

            If m_pChannelControl_LIVE(3).Visible = True Then

                CloneChannelPanel4.Visible = True

                If m_hCapDev(3) <> 0 Then

                    EXPORTS.QCAP_CREATE_CLONE(m_hCapDev(3), CloneChannelPanel4.Handle.ToInt32(), m_hCloneCapDev(3), 1)

                    If m_hCloneCapDev(3) <> 0 Then

                        EXPORTS.QCAP_RUN(m_hCloneCapDev(3))

                        EXPORTS.QCAP_SET_AUDIO_VOLUME(m_hCloneCapDev(3), 0)

                    End If

                End If

            End If

        Else

            m_bShowClone = False

            If m_pChannelControl_LIVE(0).Visible = True Then

                CloneChannelPanel1.Visible = False

                If m_hCloneCapDev(0) <> 0 Then

                    EXPORTS.QCAP_STOP(m_hCloneCapDev(0)) : EXPORTS.QCAP_DESTROY(m_hCloneCapDev(0)) : m_hCloneCapDev(0) = 0

                End If

            End If

            If m_pChannelControl_LIVE(1).Visible = True Then

                CloneChannelPanel2.Visible = False

                If m_hCloneCapDev(1) <> 0 Then

                    EXPORTS.QCAP_STOP(m_hCloneCapDev(1)) : EXPORTS.QCAP_DESTROY(m_hCloneCapDev(1)) : m_hCloneCapDev(1) = 0

                End If

            End If

            If m_pChannelControl_LIVE(2).Visible = True Then

                CloneChannelPanel3.Visible = False

                If m_hCloneCapDev(2) <> 0 Then

                    EXPORTS.QCAP_STOP(m_hCloneCapDev(2)) : EXPORTS.QCAP_DESTROY(m_hCloneCapDev(2)) : m_hCloneCapDev(2) = 0

                End If

            End If

            If m_pChannelControl_LIVE(3).Visible = True Then

                CloneChannelPanel4.Visible = False

                If m_hCloneCapDev(3) <> 0 Then

                    EXPORTS.QCAP_STOP(m_hCloneCapDev(3)) : EXPORTS.QCAP_DESTROY(m_hCloneCapDev(3)) : m_hCloneCapDev(3) = 0

                End If

            End If

        End If

    End Sub

    Public Sub OnLButtonDown_ChannelControl(ByVal nChannelNumber As UInt32)

        Dim i As UInt32 = 0

        If (m_bIsMaximizedChannelWindow(nChannelNumber - 1)) Then

            m_bIsMaximizedChannelWindow(nChannelNumber - 1) = False

            For i = 0 To 3

                ' LEFT POSITION
                '
                If i = 0 Then : m_pChannelControl_LIVE(i).Left = 0 : End If

                If i = 1 Then : m_pChannelControl_LIVE(i).Left = Me.Width / 2 : End If

                If i = 2 Then : m_pChannelControl_LIVE(i).Left = 0 : End If

                If i = 3 Then : m_pChannelControl_LIVE(i).Left = Me.Width / 2 : End If

                ' TOP POSITION
                '
                If i = 0 Then : m_pChannelControl_LIVE(i).Top = 0 : End If

                If i = 1 Then : m_pChannelControl_LIVE(i).Top = 0 : End If

                If i = 2 Then : m_pChannelControl_LIVE(i).Top = Me.Height / 2 : End If

                If i = 3 Then : m_pChannelControl_LIVE(i).Top = Me.Height / 2 : End If

                m_pChannelControl_LIVE(i).Size = New System.Drawing.Size(Me.Width / 2, Me.Height / 2)

                m_pChannelControl_LIVE(i).Visible = True

            Next

            CloneChannelPanel1.Left = 0 : CloneChannelPanel1.Top = 0 : CloneChannelPanel1.Width = 160 : CloneChannelPanel1.Height = 120 : CloneChannelPanel1.Visible = m_bShowClone

            CloneChannelPanel2.Left = Me.Width / 2 : CloneChannelPanel2.Top = 0 : CloneChannelPanel2.Width = 160 : CloneChannelPanel2.Height = 120 : CloneChannelPanel2.Visible = m_bShowClone

            CloneChannelPanel3.Left = 0 : CloneChannelPanel3.Top = Me.Height / 2 : CloneChannelPanel3.Width = 160 : CloneChannelPanel3.Height = 120 : CloneChannelPanel3.Visible = m_bShowClone

            CloneChannelPanel4.Left = Me.Width / 2 : CloneChannelPanel4.Top = Me.Height / 2 : CloneChannelPanel4.Width = 160 : CloneChannelPanel4.Height = 120 : CloneChannelPanel4.Visible = m_bShowClone

        Else

            m_bIsMaximizedChannelWindow(nChannelNumber - 1) = True

            For i = 0 To 3 : m_pChannelControl_LIVE(i).Visible = False : Next

            CloneChannelPanel1.Visible = False : CloneChannelPanel2.Visible = False : CloneChannelPanel3.Visible = False : CloneChannelPanel4.Visible = False

            m_pChannelControl_LIVE(nChannelNumber - 1).Left = 0

            m_pChannelControl_LIVE(nChannelNumber - 1).Top = 0

            m_pChannelControl_LIVE(nChannelNumber - 1).Size = New System.Drawing.Size(Me.Width, Me.Height)

            m_pChannelControl_LIVE(nChannelNumber - 1).Visible = True

            If nChannelNumber = 1 Then : CloneChannelPanel1.Left = 0 : CloneChannelPanel1.Top = 0 : CloneChannelPanel1.Width = 160 : CloneChannelPanel1.Height = 120 : CloneChannelPanel1.Visible = m_bShowClone : End If

            If nChannelNumber = 2 Then : CloneChannelPanel2.Left = Me.Width / 2 : CloneChannelPanel2.Top = 0 : CloneChannelPanel2.Width = 160 : CloneChannelPanel2.Height = 120 : CloneChannelPanel2.Visible = m_bShowClone : End If

            If nChannelNumber = 3 Then : CloneChannelPanel3.Left = 0 : CloneChannelPanel3.Top = Me.Height / 2 : CloneChannelPanel3.Width = 160 : CloneChannelPanel3.Height = 120 : CloneChannelPanel3.Visible = m_bShowClone : End If

            If nChannelNumber = 4 Then : CloneChannelPanel4.Left = Me.Width / 2 : CloneChannelPanel4.Top = Me.Height / 2 : CloneChannelPanel4.Width = 160 : CloneChannelPanel4.Height = 120 : CloneChannelPanel4.Visible = m_bShowClone : End If

        End If

    End Sub

    Public Sub OnRButtonDown_ChannelControl(ByVal nChannelNumber As UInt32)

        Dim i As UInt32 = 0

        If m_bIsMaximizedForm = False Then

            Me.WindowState = FormWindowState.Maximized

            m_bIsMaximizedForm = True

        Else

            Me.WindowState = FormWindowState.Normal

            m_bIsMaximizedForm = False

        End If

        If (m_bIsMaximizedChannelWindow(nChannelNumber - 1) = True) Then

            m_pChannelControl_LIVE(nChannelNumber - 1).Left = 0

            m_pChannelControl_LIVE(nChannelNumber - 1).Top = 0

            m_pChannelControl_LIVE(nChannelNumber - 1).Size = New System.Drawing.Size(Me.Width, Me.Height)

            m_pChannelControl_LIVE(nChannelNumber - 1).Visible = True

            If nChannelNumber = 1 Then : CloneChannelPanel1.Left = Me.Width - 320 : CloneChannelPanel1.Top = Me.Height - 240 : CloneChannelPanel1.Width = 320 : CloneChannelPanel1.Height = 240 : CloneChannelPanel1.Visible = m_bShowClone : End If

            If nChannelNumber = 2 Then : CloneChannelPanel2.Left = Me.Width - 320 : CloneChannelPanel2.Top = Me.Height - 240 : CloneChannelPanel2.Width = 320 : CloneChannelPanel2.Height = 240 : CloneChannelPanel2.Visible = m_bShowClone : End If

            If nChannelNumber = 3 Then : CloneChannelPanel3.Left = Me.Width - 320 : CloneChannelPanel3.Top = Me.Height - 240 : CloneChannelPanel3.Width = 320 : CloneChannelPanel3.Height = 240 : CloneChannelPanel3.Visible = m_bShowClone : End If

            If nChannelNumber = 4 Then : CloneChannelPanel4.Left = Me.Width - 320 : CloneChannelPanel4.Top = Me.Height - 240 : CloneChannelPanel4.Width = 320 : CloneChannelPanel4.Height = 240 : CloneChannelPanel4.Visible = m_bShowClone : End If

        Else

            For i = 0 To 3

                ' LEFT POSITION
                '
                If i = 0 Then : m_pChannelControl_LIVE(i).Left = 0 : End If

                If i = 1 Then : m_pChannelControl_LIVE(i).Left = Me.Width / 2 : End If

                If i = 2 Then : m_pChannelControl_LIVE(i).Left = 0 : End If

                If i = 3 Then : m_pChannelControl_LIVE(i).Left = Me.Width / 2 : End If

                ' TOP POSITION
                '
                If i = 0 Then : m_pChannelControl_LIVE(i).Top = 0 : End If

                If i = 1 Then : m_pChannelControl_LIVE(i).Top = 0 : End If

                If i = 2 Then : m_pChannelControl_LIVE(i).Top = Me.Height / 2 : End If

                If i = 3 Then : m_pChannelControl_LIVE(i).Top = Me.Height / 2 : End If

                m_pChannelControl_LIVE(i).Size = New System.Drawing.Size(Me.Width / 2, Me.Height / 2)

                m_pChannelControl_LIVE(i).Visible = True

            Next

            CloneChannelPanel1.Left = 0 : CloneChannelPanel1.Top = 0 : CloneChannelPanel1.Width = 160 : CloneChannelPanel1.Height = 120 : CloneChannelPanel1.Visible = m_bShowClone

            CloneChannelPanel2.Left = Me.Width / 2 : CloneChannelPanel2.Top = 0 : CloneChannelPanel2.Width = 160 : CloneChannelPanel2.Height = 120 : CloneChannelPanel2.Visible = m_bShowClone

            CloneChannelPanel3.Left = 0 : CloneChannelPanel3.Top = Me.Height / 2 : CloneChannelPanel3.Width = 160 : CloneChannelPanel3.Height = 120 : CloneChannelPanel3.Visible = m_bShowClone

            CloneChannelPanel4.Left = Me.Width / 2 : CloneChannelPanel4.Top = Me.Height / 2 : CloneChannelPanel4.Width = 160 : CloneChannelPanel4.Height = 120 : CloneChannelPanel4.Visible = m_bShowClone

        End If

    End Sub

    Private Sub SetupControlClosed(ByVal sender As System.Object, ByVal e As System.EventArgs)

        Me.Close()

    End Sub

    Private Sub Form1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Click

    End Sub

    Private Sub timerCheckSignal_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles timerCheckSignal.Tick

        ' DISPLAY FORMAT CHANGED MESSAGE
        '
        If m_bNoSignal(0) = True Then

            m_cSetupControl.m_strFormatChangedOutput1 = " INFO :  . . ."

        Else

            m_cSetupControl.m_strFormatChangedOutput1 = m_strFormatChangedOutput(0)

        End If

        If m_bNoSignal(1) = True Then

            m_cSetupControl.m_strFormatChangedOutput2 = " INFO :  . . ."

        Else

            m_cSetupControl.m_strFormatChangedOutput2 = m_strFormatChangedOutput(1)

        End If

        If m_bNoSignal(2) = True Then

            m_cSetupControl.m_strFormatChangedOutput3 = " INFO :  . . ."

        Else

            m_cSetupControl.m_strFormatChangedOutput3 = m_strFormatChangedOutput(2)

        End If

        If m_bNoSignal(3) = True Then

            m_cSetupControl.m_strFormatChangedOutput4 = " INFO :  . . ."

        Else

            m_cSetupControl.m_strFormatChangedOutput4 = m_strFormatChangedOutput(3)

        End If

        m_cSetupControl.m_bNoSignal1 = m_bNoSignal(0)

        m_cSetupControl.m_bNoSignal2 = m_bNoSignal(1)

        m_cSetupControl.m_bNoSignal3 = m_bNoSignal(2)

        m_cSetupControl.m_bNoSignal4 = m_bNoSignal(3)

    End Sub

End Class
