#define _QCAP_LABVIEW_IMPORT
typedef int                 BOOL;
#define FALSE 0
#define TRUE 1
typedef int INT;
#include <QDebug>
#include <QDesktopWidget>
#include "channelwindow.h"
#include "ui_channelwindow.h"
#include "setupdlg.h"
#include "audioinputdlg.h"
#include "videoinputdlg.h"
#include "videoqualitydlg.h"

#include "QCAP.H"

QRETURN on_process_signal_removed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
    ChannelWindow* m_pChannelWindow = (ChannelWindow*)pUserData;

    qDebug("signal removed \n");

    m_pChannelWindow->str_info.sprintf("info...(signal removed)");

    return QCAP_RT_OK;
}

QRETURN on_process_no_signal_detected( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
    ChannelWindow* m_pChannelWindow = (ChannelWindow*)pUserData;

    qDebug("no signal Detected  \n");

    m_pChannelWindow->str_info.sprintf("info...(no signal detected)");

    return QCAP_RT_OK;
}

QRETURN on_process_format_changed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample,  ULONG nAudioSampleFrequency, PVOID pUserData )
{
    ChannelWindow* m_pChannelWindow = (ChannelWindow*)pUserData;

    qDebug("format changed Detected  \n");

    CHAR strVideoInput[ MAX_PATH ] = { 0 };

    CHAR strAudioInput[ MAX_PATH ] = { 0 };

    CHAR strFrameType[ MAX_PATH ] = { 0 };

    m_pChannelWindow->m_nVideoWidth = nVideoWidth;

    m_pChannelWindow->m_nVideoHeight = nVideoHeight;

    m_pChannelWindow->m_bVideoIsInterleaved = bVideoIsInterleaved;

    m_pChannelWindow->m_dVideoFrameRate = dVideoFrameRate;

    m_pChannelWindow->m_nAudioChannels = nAudioChannels;

    m_pChannelWindow->m_nAudioBitsPerSample = nAudioBitsPerSample;

    m_pChannelWindow->m_nAudioSampleFrequency = nAudioSampleFrequency;

    m_pChannelWindow->m_nVideoInput = nVideoInput;

    m_pChannelWindow->m_nAudioInput = nAudioInput;

    UINT nVH = 0;

    if ( nVideoInput == 0 ) { sprintf( strVideoInput, "COMPOSITE" ); }

    if ( nVideoInput == 1 ) { sprintf( strVideoInput, "SVIDEO" ); }

    if ( nVideoInput == 2 ) { sprintf( strVideoInput, "HDMI" );}

    if ( nVideoInput == 3 ) { sprintf( strVideoInput, "DVI_D" );}

    if ( nVideoInput == 4 ) { sprintf( strVideoInput, "COMPONENTS (YCBCR)" );}

    if ( nVideoInput == 5 ) { sprintf( strVideoInput, "DVI_A (RGB / VGA)" );}

    if ( nVideoInput == 6 ) { sprintf( strVideoInput, "SDI" );}

    if ( nVideoInput == 7 ) { sprintf( strVideoInput, "AUTO" );}

    if ( nAudioInput == 0 ) { sprintf( strAudioInput, "EMBEDDED_AUDIO" );}

    if ( nAudioInput == 1 ) { sprintf( strAudioInput, "LINE_IN" );}

    if ( nAudioInput == 2 ) { sprintf( strAudioInput, "SOUNDCARD_MICROPHONE" );}

    if ( nAudioInput == 3 ) { sprintf( strAudioInput, "SOUNDCARD_LINE_IN" );}

    if ( bVideoIsInterleaved == TRUE ) { nVH = nVideoHeight / 2; } else { nVH = nVideoHeight; }

    if ( bVideoIsInterleaved == TRUE ) { sprintf( strFrameType, " I " ); } else { sprintf( strFrameType, " P " ); }

    m_pChannelWindow->str_info.sprintf("INFO : %d x %d%s @%2.3f FPS , %d CH x %d BITS x %d HZ ,  VIDEO INPUT : %s ,  AUDIO INPUT : %s"

                                        , nVideoWidth, nVH, strFrameType, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample

                                        , nAudioSampleFrequency, strVideoInput, strAudioInput);

    return QCAP_RT_OK;
}

QRETURN on_video_preview_callback( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
    return QCAP_RT_OK;
}

QRETURN on_process_preview_audio_buffer( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
    return QCAP_RT_OK;
}

ChannelWindow::ChannelWindow(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::ChannelWindow)
{
    ui->setupUi(this);

    this->setWindowTitle("SC510 N1");

    this->setWindowFlags(Qt::FramelessWindowHint);

    this->resize(960,540);

    ui->PreviewWindow->resize(960,540);

    ui->PreviewWindow->setLineWidth(0);

    ui->CloneWindow->move(960-320,540-240);

    ui->CloneWindow->resize(320,240);

    ui->CloneWindow->setLineWidth(0);

    ui->CloneWindow->close();

    path = QCoreApplication::applicationDirPath();

    CoInitialize( NULL );

    //CONNET SIGNAL & SLOT

    m_setupdlg = new SetUpDlg(this);

    m_setupdlg->show();

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_VideoInput()), this, SLOT(SetUpDialogSlot_VideoInput()));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_AudioInput()), this, SLOT(SetUpDialogSlot_AudioInput()));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_Snapshot_BMP()), this, SLOT(SetUpDialogSlot_Snapshot_BMP()));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_Snapshot_JPG()), this, SLOT(SetUpDialogSlot_Snapshot_JPG()));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_StartRecord11()), this, SLOT(SetUpDialogSlot_startrecord11()));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_StopRecord11()), this, SLOT(SetUpDialogSlot_stoprecord11()));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_StartRecord12()), this, SLOT(SetUpDialogSlot_startrecord12()));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_StopRecord12()), this, SLOT(SetUpDialogSlot_stoprecord12()));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_StartRecord13()), this, SLOT(SetUpDialogSlot_startrecord13()));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_StopRecord13()), this, SLOT(SetUpDialogSlot_stoprecord13()));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_VideoQuality()), this, SLOT(SetUpDialogSlot_VideoQuality()));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_DEINTERLACE( int )), this, SLOT(SetUpDialogSlot_DEINTERLACE( int )));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_CLONE( int )), this, SLOT(SetUpDialogSlot_CLONE( int )));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_DestroyAP()), this, SLOT(SetUpDialogSlot_DestroyAP()));

    //INITIALIZE MEMBER VARIABLES

    m_hVideoDevice = NULL;

    m_hCloneCapDev = NULL;

    m_nVideoWidth = 0;

    m_nVideoHeight = 0;

    m_bVideoIsInterleaved = 0;

    m_dVideoFrameRate = 0;

    m_nAudioChannels = 0;

    m_nAudioBitsPerSample = 0;

    m_nAudioSampleFrequency = 0;

    m_nVideoInput = QCAP_INPUT_TYPE_AUTO;

    m_nAudioInput = QCAP_INPUT_TYPE_EMBEDDED_AUDIO;

    m_bSupportGPU1 = FALSE;

    m_bSupportGPU2 = FALSE;

    m_bSupportGPU3 = FALSE;

    m_bMP4_11 = TRUE;

    m_bMP4_12 = TRUE;

    m_bMP4_13 = TRUE;

    m_bFullScreen = FALSE;

    HwInitialize();
}

void ChannelWindow::HwInitialize()
{
    //CREATE CAPTURE DEVICE

    QCAP_CREATE( "SA7160 PCI", 0, (HWND)ui->PreviewWindow->winId(), &m_hVideoDevice, TRUE);

    QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_hVideoDevice, on_process_no_signal_detected, this );

    QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_hVideoDevice, on_process_signal_removed, this );

    QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_hVideoDevice, on_process_format_changed, this );

    QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_hVideoDevice, on_video_preview_callback, this );

    QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_hVideoDevice, on_process_preview_audio_buffer, this );

    QCAP_SET_VIDEO_INPUT( m_hVideoDevice, QCAP_INPUT_TYPE_AUTO );

    QCAP_SET_AUDIO_INPUT( m_hVideoDevice, QCAP_INPUT_TYPE_EMBEDDED_AUDIO );

    QCAP_SET_AUDIO_VOLUME( m_hVideoDevice, 100 );

    QCAP_SET_VIDEO_DEINTERLACE( m_hVideoDevice, 1 );

    QCAP_RUN( m_hVideoDevice );

    if( m_hVideoDevice == 0 )
    {
        str_info.sprintf("create fail");
    }
}

void ChannelWindow::HwUninitialize()
{
    //DESTROY CAPTURE DEVICE

    if( m_hCloneCapDev != 0 )
    {
        QCAP_STOP( m_hCloneCapDev );

        QCAP_DESTROY( m_hCloneCapDev );

        m_hCloneCapDev = NULL;
    }

    if( m_hVideoDevice ) {

        QCAP_STOP( m_hVideoDevice );

        QCAP_DESTROY( m_hVideoDevice );

        m_hVideoDevice = NULL;
    }

    CoUninitialize();
}

ChannelWindow::~ChannelWindow()
{
    delete ui;
}

void ChannelWindow::SetUpDialogSlot_VideoInput()
{
    VideoInputDlg video_input(this);

    video_input.exec();
}

void ChannelWindow::SetUpDialogSlot_AudioInput()
{
    AudioInputDlg audio_input(this);

    audio_input.exec();
}

void ChannelWindow::SetUpDialogSlot_Snapshot_BMP()
{
    QString bmp_path = path + QString("/Snapshot_BMP.bmp");

    QByteArray bmp_path_ByteArray = bmp_path.toLocal8Bit();

    CHAR* psz = bmp_path_ByteArray.data();

    QCAP_SNAPSHOT_BMP( m_hVideoDevice, psz );
}

void ChannelWindow::SetUpDialogSlot_Snapshot_JPG()
{
    QString jpg_path = path + QString("/Snapshot_JPG.jpg");

    QByteArray jpg_path_ByteArray =jpg_path.toLocal8Bit();

    CHAR* psz = jpg_path_ByteArray.data();

    QCAP_SNAPSHOT_JPG( m_hVideoDevice, psz, 100 );
}

void ChannelWindow::SetUpDialogSlot_startrecord11()
{
    QRESULT return_type = QCAP_RS_ERROR_GENERAL;

    QString record1_path;

    if( m_bSupportGPU1 == TRUE )
    {
        QCAP_SET_VIDEO_RECORD_PROPERTY( m_hVideoDevice, 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
    }
    else
    {
        QCAP_SET_VIDEO_RECORD_PROPERTY( m_hVideoDevice, 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 8 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
    }

    if( m_bMP4_11 )
    {
        record1_path = path + QString("/record_1.mp4");

        QCAP_SET_AUDIO_RECORD_PROPERTY( m_hVideoDevice, 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );
    }
    else
    {
        record1_path = path + QString("/record_1.avi");

        QCAP_SET_AUDIO_RECORD_PROPERTY( m_hVideoDevice, 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );
    }

    QByteArray record1_path_ByteArray =record1_path.toLocal8Bit();

    CHAR* psz = record1_path_ByteArray.data();

    return_type = QCAP_START_RECORD( m_hVideoDevice, 0, psz);

    if( return_type == QCAP_RS_SUCCESSFUL )
    {
        qDebug("start record 1_1");
    }
    else
    {
        qDebug("start record 1_1");
    }
}

void ChannelWindow::SetUpDialogSlot_stoprecord11()
{
    QCAP_STOP_RECORD( m_hVideoDevice, 0 );

    qDebug("stop record 1_1");
}

void ChannelWindow::SetUpDialogSlot_startrecord12()
{
    QRESULT return_type = QCAP_RS_ERROR_GENERAL;

    QString record2_path;

    if( m_bSupportGPU2 == TRUE )
    {
        QCAP_SET_VIDEO_RECORD_PROPERTY( m_hVideoDevice, 1, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 4 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );
    }
    else
    {
        QCAP_SET_VIDEO_RECORD_PROPERTY( m_hVideoDevice, 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 4 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );
    }

    if( m_bMP4_12 )
    {
        record2_path = path + QString("/record_2.mp4");

        QCAP_SET_AUDIO_RECORD_PROPERTY( m_hVideoDevice, 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );
    }
    else
    {
        record2_path = path + QString("/record_2.avi");

        QCAP_SET_AUDIO_RECORD_PROPERTY( m_hVideoDevice, 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );
    }

    QByteArray record2_path_ByteArray =record2_path.toLocal8Bit();

    CHAR* psz = record2_path_ByteArray.data();

    return_type = QCAP_START_RECORD( m_hVideoDevice, 1, psz);

    if( return_type == QCAP_RS_SUCCESSFUL )
    {
        qDebug("start record 1_2");
    }
    else
    {
        qDebug("start record 1_2");
    }
}

void ChannelWindow::SetUpDialogSlot_stoprecord12()
{
    QCAP_STOP_RECORD( m_hVideoDevice, 1 );

    qDebug("stop record 1_2");
}

void ChannelWindow::SetUpDialogSlot_startrecord13()
{
    QRESULT return_type = QCAP_RS_ERROR_GENERAL;

    QString record3_path;

    if( m_bSupportGPU3 == TRUE )
    {
        QCAP_SET_VIDEO_RECORD_PROPERTY( m_hVideoDevice, 2, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 2 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_4 );
    }
    else
    {
        QCAP_SET_VIDEO_RECORD_PROPERTY( m_hVideoDevice, 2, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 2 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_4 );
    }

    if( m_bMP4_13 )
    {
        record3_path = path + QString("/record_3.mp4");

        QCAP_SET_AUDIO_RECORD_PROPERTY( m_hVideoDevice, 2, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );
    }
    else
    {
        record3_path = path + QString("/record_3.avi");

        QCAP_SET_AUDIO_RECORD_PROPERTY( m_hVideoDevice, 2, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );
    }

    QByteArray record3_path_ByteArray =record3_path.toLocal8Bit();

    CHAR* psz = record3_path_ByteArray.data();

    return_type = QCAP_START_RECORD( m_hVideoDevice, 2, psz);

    if( return_type == QCAP_RS_SUCCESSFUL )
    {
        qDebug("start record 1_3");
    }
    else
    {
        qDebug("start record 1_3");
    }
}

void ChannelWindow::SetUpDialogSlot_stoprecord13()
{
    QCAP_STOP_RECORD( m_hVideoDevice, 2 );

    qDebug("stop record 1_3");
}

void ChannelWindow::SetUpDialogSlot_VideoQuality()
{
    VideoQualityDlg vodeo_quality(this);

    vodeo_quality.exec();
}

void ChannelWindow::SetUpDialogSlot_DEINTERLACE( int flag )
{
    if( m_hVideoDevice )
    {
        if( flag == 0 )
        {
            QCAP_SET_VIDEO_DEINTERLACE( m_hVideoDevice, 0 );
        }
        else
        {
            QCAP_SET_VIDEO_DEINTERLACE( m_hVideoDevice, 1 );
        }
    }
}

void ChannelWindow::SetUpDialogSlot_CLONE( int flag )
{
    if( m_hVideoDevice )
    {
        if( flag == 0 )
        {
            QCAP_STOP( m_hCloneCapDev );

            QCAP_DESTROY( m_hCloneCapDev );

            m_hCloneCapDev = NULL;

            ui->CloneWindow->close();
        }
        else
        {
            QCAP_CREATE_CLONE( m_hVideoDevice, (HWND)ui->CloneWindow->winId(), &m_hCloneCapDev, 1 );

            ui->CloneWindow->show();

            if( m_hCloneCapDev != 0 )
            {
                QCAP_RUN( m_hCloneCapDev );

                QCAP_SET_AUDIO_VOLUME( m_hCloneCapDev, 0 );
            }
        }
    }
}

void ChannelWindow::mouseMoveEvent(QMouseEvent *event)
{
    if(event->buttons()&Qt::LeftButton)
    {
        move(event->globalPos()- dragPosition);

        event->accept();
    }
}

void ChannelWindow::mousePressEvent(QMouseEvent *event)
{
    if(event->button()==Qt::LeftButton)
    {
        dragPosition=event->globalPos()-frameGeometry().topLeft();

        event->accept();
    }
}

void ChannelWindow::mouseDoubleClickEvent( QMouseEvent * event )
{
    if( event->button()==Qt::LeftButton )
    {
        QDesktopWidget *desktop = QApplication::desktop();

        QRect screen = desktop->screenGeometry();

        if( m_bFullScreen == FALSE)
        {
            this->move(0,0);

            this->resize(screen.width(),screen.height());

            ui->PreviewWindow->resize(screen.width(),screen.height());

            ui->CloneWindow->move(screen.width()-320,screen.height()-240);

            ui->CloneWindow->resize(320,240);

            m_bFullScreen = TRUE;
        }
        else
        {
            this->move((screen.width()-960)/2,(screen.height()-540)/2);

            this->resize(960,540);

            ui->PreviewWindow->resize(960,540);

            ui->CloneWindow->move(960-320,540-240);

            ui->CloneWindow->resize(320,240);

            m_bFullScreen = FALSE;
        }

        event->accept();
    }
}

void ChannelWindow::SetUpDialogSlot_DestroyAP()
{
    HwUninitialize();

    exit(0);
}
