// CBaseCap.cpp : Defines the initialization routines for the DLL.
//

#include "stdafx.h"
#include "CBaseCap.h"
#include "CCaptureDeviceh.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#endif

extern HMODULE g_hModule;

CCaptureDevice * g_pCCaptureDevice = NULL;

VOID DumpDebugMessage( CHAR * fmt, ... )
{
	CHAR pszDebugDumpMessage[ MAX_PATH ] = "[QC.CAPTURE.LIB] ";
	
	va_list marker;

	va_start( marker, fmt);

	vsprintf( pszDebugDumpMessage + 17, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

EXTERN_C CAP_API ADO_RESULT ADO_CAPTURE_EXPORT RecevieAdobeCaptureEvents( ULONG nEvent, PVOID pAttachedData )
{
	CHAR psz[ MAX_PATH ];

	switch( nEvent )
	{
		case ADOBE_PLUGIN_STARTUP_EVENT :
		{
			DumpDebugMessage( "RecevieAdobeCaptureEvent : ADOBE_PLUGIN_STARTUP_EVENT \n" );

			// CREATE CAPTURE DEVICE OBJECT, OBTAIN SOME INTERFACES
			//
			if ( g_pCCaptureDevice == NULL )
			{
				g_pCCaptureDevice = new CCaptureDevice();

				g_pCCaptureDevice->Shartup();
			}

			break;
		}

		case ADOBE_PLUGIN_SHUTDOWN_EVENT :
		{
			DumpDebugMessage( "RecevieAdobeCaptureEvent : ADOBE_PLUGIN_SHUTDOWN_EVENT \n" );

			// RELEASE CAPTURE DEVICE OBJECT
			//			
			if ( g_pCCaptureDevice != NULL )
			{				
				g_pCCaptureDevice->ShutDown();

				delete g_pCCaptureDevice;

				g_pCCaptureDevice = NULL;					
			}

			break;
		}

		case ADOBE_PLUGIN_DISPLAY_WND_EVENT:
		{
			sprintf( psz, "RecevieAdobeCaptureEvent -> ADOBE_PLUGIN_DISPLAY_WND_EVENT -> HWND : %016X% \n", pAttachedData ); DumpDebugMessage( psz );			

			if ( g_pCCaptureDevice != NULL )
			{
				g_pCCaptureDevice->SetAttachedWindow( (HWND)pAttachedData );
			}

			break;
		}

		case ADOBE_PLUGIN_START_PREVIEW_EVENT :
		{
			sprintf( psz, "RecevieAdobeCaptureEvent -> ADOBE_PLUGIN_START_PREVIEW_EVENT -> DEVICE : %s \n", (CHAR *) pAttachedData ); DumpDebugMessage( psz );			

			if ( g_pCCaptureDevice != NULL )
			{
				if ( g_pCCaptureDevice->GetAttachedWindow() != NULL )
				{
					g_pCCaptureDevice->SetDeviceName( (CHAR *)pAttachedData );

					g_pCCaptureDevice->Initialize();

					g_pCCaptureDevice->StartPreview();
				}
			}

			break;
		}

		case ADOBE_PLUGIN_STOP_PREVIEW_EVENT :
		{
			DumpDebugMessage( "RecevieAdobeCaptureEvent : ADOBE_PLUGIN_STOP_PREVIEW_EVENT \n" );

			if ( g_pCCaptureDevice != NULL )
			{
				g_pCCaptureDevice->StopPreview();

				g_pCCaptureDevice->UnInitialize();
			}

			break;
		}

		case ADOBE_PLUGIN_START_RECORD_EVENT :
		{
			DumpDebugMessage( "RecevieAdobeCaptureEvent : ADOBE_PLUGIN_START_RECORD_EVENT \n" );

			if ( g_pCCaptureDevice != NULL )
			{
				g_pCCaptureDevice->StartRecord();
			}

			break;
		}

		case ADOBE_PLUGIN_PAUSE_RECORD_EVENT :
		{
			DumpDebugMessage( "RecevieAdobeCaptureEvent : ADOBE_PLUGIN_PAUSE_RECORD_EVENT \n" );

			if ( g_pCCaptureDevice != NULL )
			{
				g_pCCaptureDevice->PauseRecord();
			}

			break;
		}

		case ADOBE_PLUGIN_STOP_RECORD_EVENT :
		{
			DumpDebugMessage( "RecevieAdobeCaptureEvent : ADOBE_PLUGIN_STOP_RECORD_EVENT \n" );

			if ( g_pCCaptureDevice != NULL )
			{
				g_pCCaptureDevice->StopRecord();
			}

			break;
		}

		case ADOBE_PLUGIN_SHOW_SETUP_UI_EVENT :
		{
			DumpDebugMessage( "RecevieAdobeCaptureEvent : ADOBE_PLUGIN_SHOW_SETUP_UI_EVENT \n" );

			if ( g_pCCaptureDevice != NULL )
			{
				g_pCCaptureDevice->ShowSetupUIDialog();
			}

			break;
		}

		default:
		{
			break;
		}

	}

	return ADO_RS_ERROR_GENERAL;
}