#pragma once


// CRecordWindow

class CRecordWindow : public CWnd
{
	DECLARE_DYNAMIC(CRecordWindow)

public:
	CRecordWindow();
	virtual ~CRecordWindow();

protected:
	//{{AFX_MSG(CChannelWindow)
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnPaint();
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();	
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

public:

	BOOL		m_bLocalPlay[ DEFAULT_MAX_CHANNEL_NUM ];

	double		m_dCellWidth;	

	double		m_dCellHeight;

	double		m_dDayStartTime;

	double		m_dLocalPlayTime[ DEFAULT_MAX_CHANNEL_NUM ];

	double		m_dGlobalPlayTime;

	CRect		m_rectHourNum[ 24 ];

	CPoint		m_XYPlayTriangle[ DEFAULT_MAX_CHANNEL_NUM ][ 4 ];

	CPoint		m_XYGlobalPlayTriangle[ 4 ];

	CRect		m_rectPlayTriangle[ DEFAULT_MAX_CHANNEL_NUM ];

	CRect		m_rectGlobalPlayTriangle;

	SYSTEMTIME	m_timeDaySelected;

	// CHANNEL RECT OF ALL RECORDS
	//
	CArray< CRect, CRect > m_aryCHRectData[ DEFAULT_MAX_CHANNEL_NUM ];

	CArray< CRect, CRect > m_aryGlobalCHRectData[ DEFAULT_MAX_CHANNEL_NUM ];

	void DrawHourNumBlock( HDC hDC );

	void DrawGridLine( HDC hDC );

	void DrawChannelData(HDC hDC);

	void DrawGlobalChannelData(HDC hDC);

	void DrawIndividualTrianglePointer( HDC hDC );

	void DrawGlobalTrianglePointer( HDC hDC );

	void UpdateIndividualTrianglePointer(UINT nCH);

	void UpdateGlobalTrianglePointer();

	VOID UpdateDataRect( ULONG nCH );

	VOID UpdateGlobalDataRect( ULONG nCH );	

	VOID SetPlayState( ULONG nCH );

	CRect GetTriangleRect(CPoint *point, int nSize);	
};


