
// SC510Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "SC510.h"
#include "SC510Dlg.h"
#include "VideoQualityDlg.h"
#include "VideoInputDlg.h"
#include "AduioInputDlg.h"
#include "FileRecordDialog.h"
#include "ShareRecordDialog.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

CSC510Dlg *	CSC510Dlg::m_pSC510Dlg = NULL;

VOID Dbg( CHAR* pszStr, ... )
{
	char szData[ MAX_PATH ] = "[SC510] ";

	va_list args;

	va_start( args, pszStr );

	_vsnprintf( szData + 8, sizeof( szData ) - 1, pszStr, args );

	va_end( args );

    strcat( szData, "\n" );

	OutputDebugString( szData );
}

//  FORMAT CHANGED CALLBACK FUNCTION
//
QRETURN on_process_format_changed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample,  ULONG nAudioSampleFrequency, PVOID pUserData )
{
	Dbg(" format changed Detected ! \n");

	CSC510Dlg * m_pMainDialog = CSC510Dlg::m_pSC510Dlg;
	
	ULONG nChannelNum = (ULONG)pUserData;

	if ( m_pMainDialog == NULL ) { return QCAP_RT_OK; }

	if ( m_pMainDialog->GetSafeHwnd() == NULL ) { return QCAP_RT_OK; }

	// SAVE SHARE RECORDING INFO
	//
	m_pMainDialog->m_nVideoWidth[ nChannelNum ] = nVideoWidth;

	m_pMainDialog->m_nVideoHeight[ nChannelNum ] = nVideoHeight;

	m_pMainDialog->m_dVideoFrameRate[ nChannelNum ] = dVideoFrameRate;

	// OUTPUT FORMAT CHANGED MESSAGE
	//
	CHAR strVideoInput[ MAX_PATH ] = { 0 };

	CHAR strAudioInput[ MAX_PATH ] = { 0 };

	CHAR strFrameType[ MAX_PATH ] = { 0 }; 

    UINT nVH = 0;
            
    if ( nVideoInput == 0 ) { sprintf( strVideoInput, "COMPOSITE" ); }
 	
	if ( nVideoInput == 1 ) { sprintf( strVideoInput, "SVIDEO" ); }
	
	if ( nVideoInput == 2 ) { sprintf( strVideoInput, "HDMI" ); }

    if ( nVideoInput == 3 ) { sprintf( strVideoInput, "DVI_D" ); }
	
	if ( nVideoInput == 4 ) { sprintf( strVideoInput, "COMPONENTS (YCBCR)" ); }
	
	if ( nVideoInput == 5 ) { sprintf( strVideoInput, "DVI_A (RGB / VGA)" ); }
	
    if ( nVideoInput == 6 ) { sprintf( strVideoInput, "SDI" ); }
	
	if ( nVideoInput == 7 ) { sprintf( strVideoInput, "AUTO" ); }

    if ( nAudioInput == 0 ) { sprintf( strAudioInput, "EMBEDDED_AUDIO" ); }
	
	if ( nAudioInput == 1 ) { sprintf( strAudioInput, "LINE_IN" ); }

    if ( bVideoIsInterleaved == TRUE ) { nVH = nVideoHeight / 2; } else { nVH = nVideoHeight; }

    if ( bVideoIsInterleaved == TRUE ) { sprintf( strFrameType, "I" ); } else { sprintf( strFrameType, "P" ); }
	
	m_pMainDialog->m_strFormatChangedOutput[ nChannelNum ].Format( "INFO : %d x %d%s @%2.3 FPS , %d CH x %d BITS x %d HZ ,  VIDEO INPUT : %s ,  AUDIO INPUT : %s", nVideoWidth, nVH, strFrameType, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample, nAudioSampleFrequency, strVideoInput, strAudioInput ); 

    // NO SOURCE
    //
    if( nVideoWidth == 0 && nVideoHeight == 0 && nAudioChannels == 0 && nAudioBitsPerSample == 0 && nAudioSampleFrequency == 0 ) {

		m_pMainDialog->m_bNoSignal[ nChannelNum ] = TRUE;		
	}
    else {

		m_pMainDialog->m_bNoSignal[ nChannelNum ] = FALSE;		
    }
    return QCAP_RT_OK;
}    

// NO SIGNAL DETEACTED CALLBACK FUNCTION
//
QRETURN on_process_no_signal_detected( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	CSC510Dlg * m_pMainDialog = CSC510Dlg::m_pSC510Dlg;
	
	ULONG nChannelNum = (ULONG)pUserData;

	Dbg(" No Signal Detected ! \n");

	if ( m_pMainDialog == NULL ) { return QCAP_RT_OK; }

	if ( m_pMainDialog->GetSafeHwnd() == NULL ) { return QCAP_RT_OK; }

	m_pMainDialog->m_bNoSignal[ nChannelNum ] = TRUE;

	// SAVE SHARE RECORDING INFO
	//
	m_pMainDialog->m_nVideoWidth[ nChannelNum ] = 0;

	m_pMainDialog->m_nVideoHeight[ nChannelNum ] = 0;

	return QCAP_RT_OK;
}

// SIGNAL REMOVED CALLBACK FUNCTION
//
QRETURN on_process_signal_removed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	CSC510Dlg * m_pMainDialog = CSC510Dlg::m_pSC510Dlg;
	
	ULONG nChannelNum = (ULONG)pUserData;

	Dbg(" Signal Removed ! \n");

	if ( m_pMainDialog == NULL ) { return QCAP_RT_OK; }

	if ( m_pMainDialog->GetSafeHwnd() == NULL ) { return QCAP_RT_OK; }

	m_pMainDialog->m_bNoSignal[ nChannelNum ] = TRUE;

	// SAVE SHARE RECORDING INFO
	//
	m_pMainDialog->m_nVideoWidth[ nChannelNum ] = 0;

	m_pMainDialog->m_nVideoHeight[ nChannelNum ] = 0;

    return QCAP_RT_OK;
}    

// PREVIEW VIDEO CALLBACK FUNCTION
//
QRETURN on_process_preview_video_buffer( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
	CSC510Dlg * m_pMainDialog = CSC510Dlg::m_pSC510Dlg;

	ULONG nChannelNum = (ULONG)pUserData;

	if ( m_pMainDialog->m_bIsShareRecord && m_pMainDialog->m_bShareRecordCH[ nChannelNum ] ) 
	{		
		QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, MAKEFOURCC('Y', 'U', 'Y', '2'), m_pMainDialog->m_nVideoWidth[ nChannelNum ], m_pMainDialog->m_nVideoHeight[ nChannelNum ], pFrameBuffer, nFrameBufferLen );

		//QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, MAKEFOURCC('Y', 'V', '1', '2'), m_pMainDialog->m_nVideoWidth[ nChannelNum ], m_pMainDialog->m_nVideoHeight[ nChannelNum ], pFrameBuffer, nFrameBufferLen );
	}

    return QCAP_RT_OK;
}

// PREVIEW AUDIO CALLBACK FUNCTION
//
QRETURN on_process_preview_audio_buffer( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
	CSC510Dlg * m_pMainDialog = CSC510Dlg::m_pSC510Dlg;

	ULONG nChannelNum = (ULONG)pUserData;

	if (m_pMainDialog->m_bIsShareRecord && m_pMainDialog->m_bShareRecordCH[ nChannelNum ] ) 
	{
		QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, pFrameBuffer, nFrameBufferLen );
	}

	return QCAP_RT_OK;
}

// CSC510Dlg dialog

CSC510Dlg::CSC510Dlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CSC510Dlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_nWndState					= 0x00000000;		// 0 = SPLIT, 1 = FULL SCREEN

	m_nCurSelectChannelNumber	= -1;

	m_nAudioPlayChannel			= -1;

	m_bIsShareRecord			= FALSE;

	m_bShareSupportGPU1_1		= FALSE;

	for ( ULONG i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++ )
	{
		m_hVideoDevice[ i ]						= NULL;

		m_hCloneCapDev[ i ]						= NULL;

		m_nVideoWidth[ i ]						= 0;

		m_nVideoHeight[ i ]						= 0;

		m_bVideoIsInterleaved[ i ]				= FALSE;

		m_bShareRecordCH[ i ]					= FALSE;

		m_dVideoFrameRate[ i ]					= 0.0;			

		m_nAudioChannels[ i ]					= 2;

		m_nAudioBitsPerSample[ i ]				= 16;

		m_nAudioSampleFrequency[ i ]			= 48000;
			
		m_bNoSignal[ i ]						= TRUE;

		m_nSharpness[ i ]						= 128;

		m_nSaturation[ i ]						= 128;

		m_nHue[ i ]								= 128;

		m_nConstrast[ i ]						= 128;

		m_nBrightness[ i ]						= 128;

		m_rect_slipts_display[ i ].left			= 0;

		m_rect_slipts_display[ i ].top			= 0;

		m_rect_slipts_display[ i ].right		= 0;

		m_rect_slipts_display[ i ].bottom		= 0;

		m_rect_slipts_display_clone[ i ].left	= 0;

		m_rect_slipts_display_clone[ i ].top	= 0;

		m_rect_slipts_display_clone[ i ].right	= 0;

		m_rect_slipts_display_clone[ i ].bottom = 0;
	}

	m_bSupportGPU1_1 = m_bIsRecord1_1 = m_bSupportGPU1_2 = m_bIsRecord1_2 = m_bSupportGPU2_1 = m_bIsRecord2_1 = m_bSupportGPU2_2 = m_bIsRecord2_2 = FALSE;
	
	m_bSupportGPU3_1 = m_bIsRecord3_1 = m_bSupportGPU3_2 = m_bIsRecord3_2 = m_bSupportGPU4_1 = m_bIsRecord4_1 = m_bSupportGPU4_2 = m_bIsRecord4_2;
}

void CSC510Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CSC510Dlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_WM_ERASEBKGND()
	ON_WM_TIMER()	
	ON_WM_LBUTTONDOWN()
END_MESSAGE_MAP()

// CSC510Dlg message handlers

BOOL CSC510Dlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	m_pSC510Dlg = this;

	// INITIALIZE COM RESOURCE
	//
	HRESULT hr = CoInitialize( NULL );
	
	// INITIALIZE MAIN WINDOW
	//
	CRect oWindowRect; GetWindowRect( &oWindowRect );

	CRect oClientRect; GetClientRect( &oClientRect );

	ULONG cx = oWindowRect.Width() - oClientRect.Width();						// GET DEFAULT BOUNDARY WIDTH OF DIALOG

	ULONG cy = oWindowRect.Height() - oClientRect.Height();						// GET DEFAULT BOUNDARY HEIGHT OF DIALOG

	MoveWindow( 0, 0, cx + DEFAULT_NORMAL_WIDTH, cy + DEFAULT_NORMAL_HEIGHT );	// CREATE AND MAINTIN LAYOUT

	SetWindowPos( &CWnd::wndTop, 0, 0, 0, 0, SWP_NOSIZE );						// SET THE LOCATION OF MAIN DIALOG

	CHAR szStr[ MAX_PATH ] = { 0 };

	for ( ULONG i = 0; i < DEFAULT_MAX_CHANNEL_NUM; i++ )	
	{			
		m_rect_slipts_display[ i ] = GetSplitWndPos_SC510DLG( i, DEFAULT_GRID_DIVISIONS, cx + 960, cy + 540 );

		m_rect_slipts_display_clone[ i ] = CRect( m_rect_slipts_display[ i ].right - 240, m_rect_slipts_display[ i ].bottom - 120, m_rect_slipts_display[ i ].right, m_rect_slipts_display[ i ].bottom );

		sprintf( szStr, "MyChannelWindowLIVE#%02d", i + 1 );

		m_oChannelWindows_LIVE[ i ].Create(	NULL, szStr, WS_CHILD | WS_VISIBLE | WS_BORDER, m_rect_slipts_display[ i ], this, i + 0x00000001, NULL );	// VIDEO WINDOW
			
		sprintf( szStr, "MyChannelWindowBK#%02d", i + 1 );

		m_oChannelWindows_BK[ i ].Create( NULL, szStr, WS_CHILD | WS_VISIBLE | WS_BORDER, m_rect_slipts_display[ i ], this, i + 0x10000001, NULL );		// BACKGROUND WINDOW

		sprintf( szStr, "MyChannelWindowCLONE#%02d", i + 1 );

		m_oCloneWindows[ i ].m_nChannelNumber = i;

		m_oCloneWindows[ i ].Create( NULL, szStr, WS_CHILD | WS_VISIBLE | WS_BORDER, CRect( 0, 0, 0, 0 ), this, i + 0x20000001, NULL );					// CLONE WINDOW
			
		m_oCloneWindows[ i ].MoveWindow( m_rect_slipts_display_clone[ i ] );

		m_oChannelWindows_LIVE[ i ].ShowWindow( TRUE );

		m_oChannelWindows_BK[ i ].ShowWindow( FALSE );

		m_oCloneWindows[ i ].ShowWindow( FALSE );
	}

	// INITIALIZE SETUP DIALOG
	//
	HMONITOR hMonitor = MonitorFromWindow( m_hWnd, MONITOR_DEFAULTTONEAREST );			

	MONITORINFO sMonitorInfo = { sizeof(MONITORINFO), }; 
			
	GetMonitorInfo( hMonitor, &sMonitorInfo );

	CRect oMonitorRect = sMonitorInfo.rcWork;			
			
	m_oSetupDialog.Create( IDD_SETUP_DIALOG, this );

	m_oSetupDialog.GetWindowRect( &oWindowRect );

	m_oSetupDialog.GetClientRect( &oClientRect );

	cx = oWindowRect.Width() - oClientRect.Width();		// GET DEFAULT BOUNDARY WIDTH OF DIALOG

	cy = oWindowRect.Height() - oClientRect.Height();	// GET DEFAULT BOUNDARY HEIGHT OF DIALOG

	m_oSetupDialog.SetWindowPos( &(CWnd::wndTop), (oMonitorRect.Width() - (960 + cx)) / 2, (oMonitorRect.Height() - (105 + 40 + cy)), (cx + 960),  (cy + 300), (NULL));

	m_oSetupDialog.ShowWindow( TRUE );
	
	// ENABLE RECORDING SCF FILE
	//	
	QCAP_SET_SYSTEM_CONFIGURATION( TRUE, TRUE, TRUE, TRUE, TRUE, 3000, TRUE );

	HwInitialize();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSC510Dlg::OnDestroy() 
{
	KillTimer( 0x00000001 );

	// UNINITIALIZE DEVICE RESOURCE
	//
	HwUninitialize();

	// UNINITIALIZE USER INTERFACE RESOURCE
	//
	for ( ULONG i = 0; i < DEFAULT_MAX_CHANNEL_NUM; i++ )	
	{	
		m_oCloneWindows[ i ].DestroyWindow();

		m_oChannelWindows_LIVE[ i ].DestroyWindow();

		m_oChannelWindows_BK[ i ].DestroyWindow();		
	}

	m_oSetupDialog.DestroyWindow();

	// UNINITIALIZE COM RESOURCE
	//
	CoUninitialize();	
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSC510Dlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSC510Dlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

BOOL CSC510Dlg::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default

	CRect rect_client;	GetClientRect( &rect_client );

	CBrush brush_fill_rect( RGB(0, 0, 0) );

	pDC->FillRect( &rect_client, &brush_fill_rect );

	return CWnd::OnEraseBkgnd(pDC);
}

CString CSC510Dlg::GetWorkingPath(CString strWorkFile)
{
	TCHAR szCurPath[MAX_PATH] = {0};

	GetModuleFileName(NULL, szCurPath, MAX_PATH);

	CString strCurPath = szCurPath;

	strCurPath = strCurPath.Left(strCurPath.ReverseFind('\\') + 1);

	strCurPath += strWorkFile;

	return strCurPath;
}

CRect CSC510Dlg::GetSplitWndPos_SC510DLG( ULONG nChannelNumber, ULONG nGridDivisions, ULONG nRendererWidth, ULONG nRendererHeight )
{
	CHAR szStr[ MAX_PATH ] = { 0 };

	ULONG nSplitsWidth = nRendererWidth / nGridDivisions;
			
	ULONG nSplitsHeight = nRendererHeight / nGridDivisions ; 

	ULONG nMaxChannel = nGridDivisions * nGridDivisions;

	ULONG x = nChannelNumber / nGridDivisions;

	ULONG y = nChannelNumber % nGridDivisions;

	ULONG top = nSplitsWidth * y;
				
	ULONG left = nSplitsHeight * x;

	ULONG bottom = top + nSplitsWidth;

	ULONG right = left + nSplitsHeight;
			
	return CRect( top, left, bottom, right );
}

BOOL CSC510Dlg::OnLButtonDblClk_ChannelWindow( ULONG nChannelNum, UINT nFlags, CPoint point ) 
{
	// TODO: Add your message handler code here and/or call default

	HMONITOR hMonitor = MonitorFromWindow( m_hWnd, MONITOR_DEFAULTTONEAREST );	

	MONITORINFO sMonitorInfo = { sizeof(MONITORINFO), }; 

	GetMonitorInfo( hMonitor, &sMonitorInfo );

	CRect oMonitorRect = sMonitorInfo.rcMonitor;

	m_nCurSelectChannelNumber = nChannelNum;

	CHAR szStr[ MAX_PATH ] = { 0 };	
		
	// FULL TO SPLIT SCREEN
	//
	if ( m_nWndState ) 
	{			
		m_oSetupDialog.m_btnVideoInput.EnableWindow( FALSE );

		m_oSetupDialog.m_btnVideoQuality.EnableWindow( FALSE );

		m_oSetupDialog.m_btnAudioInput.EnableWindow( FALSE );

		m_oSetupDialog.m_btnAudioInput.EnableWindow( FALSE );
			
		m_oSetupDialog.m_btnSnapshot_bmp.EnableWindow( FALSE ); 

		m_oSetupDialog.m_btnSnapshot_jpg.EnableWindow( FALSE ); 
		
		for ( ULONG i = 0; i < DEFAULT_MAX_CHANNEL_NUM; i++ ) 
		{
			if ( m_oSetupDialog.m_btnShowCloneVideo.GetCheck() == TRUE ) { m_oCloneWindows[ i ].ShowWindow( TRUE ); }
			
			else { m_oCloneWindows[ i ].ShowWindow( FALSE ); }

			if ( i == nChannelNum ) 
			{
				m_oChannelWindows_LIVE[ i ].MoveWindow( m_rect_slipts_display[ i ] );

				m_oChannelWindows_BK[ i ].MoveWindow( m_rect_slipts_display[ i ] );

				m_oCloneWindows[ i ].MoveWindow( m_rect_slipts_display_clone[ i ] );

				QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ i ], 0 );				
			}
			else 
			{
				m_oChannelWindows_LIVE[ i ].ShowWindow( TRUE );

				m_oChannelWindows_BK[ i ].ShowWindow( FALSE );
			}
		}			
			
		m_nWndState = 0;
	}
	//  SPLIT TO FULL SCREEN
	//
	else 
	{		
		CRect oWindowRect; GetWindowRect( &oWindowRect );

		CRect oClientRect; GetClientRect( &oClientRect );

		ULONG cx = oWindowRect.Width() - oClientRect.Width();		// GET DEFAULT BOUNDARY WIDTH OF DIALOG

		ULONG cy = oWindowRect.Height() - oClientRect.Height();		// GET DEFAULT BOUNDARY HEIGHT OF DIALOG

		CRect rect( 0 , 0 ,  cx + DEFAULT_NORMAL_WIDTH, cy + DEFAULT_NORMAL_HEIGHT );		
		
		m_oSetupDialog.m_btnVideoInput.EnableWindow( TRUE );

		m_oSetupDialog.m_btnVideoQuality.EnableWindow( TRUE );

		m_oSetupDialog.m_btnAudioInput.EnableWindow( TRUE );

		m_oSetupDialog.m_btnAudioInput.EnableWindow( TRUE );
			
		m_oSetupDialog.m_btnSnapshot_bmp.EnableWindow( TRUE ); 

		m_oSetupDialog.m_btnSnapshot_jpg.EnableWindow( TRUE ); 		

		for ( ULONG i = 0; i < DEFAULT_MAX_CHANNEL_NUM; i++ ) 
		{
			if ( i ==  nChannelNum ) 
			{
				m_oChannelWindows_LIVE[ i ].MoveWindow( rect );
					
				m_oChannelWindows_BK[ i ].MoveWindow( rect );

				m_oCloneWindows[ i ].MoveWindow( oMonitorRect.Width() - 385, oMonitorRect.Height() - 469, 320, 240 );	

				QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ i ], 100 );
					
				m_nAudioPlayChannel = i;				
			}
			else 
			{
				m_oChannelWindows_LIVE[ i ].ShowWindow( FALSE );

				m_oChannelWindows_BK[ i ].ShowWindow( FALSE );

				m_oCloneWindows[ i ].ShowWindow( FALSE );
			}
		}
			
		m_nWndState = 1;
	} 

	return TRUE;
}

BOOL CSC510Dlg::OnButtonShareRecording_FileRecordDialog()
{
	CShareRecordDialog dlg;

	INT_PTR nResponse = -1;
	
	nResponse = dlg.DoModal();

	return true;
}

BOOL CSC510Dlg::OnButtonFileRecording_FileRecordDialog()
{
	CFileRecordDialog dlg;

	INT_PTR nResponse = -1;
	
	nResponse = dlg.DoModal();

	return true;
}

BOOL CSC510Dlg::OnButtonSnapshotBMP_SetupDialog() 
{
	ULONG nChannelNum = m_nCurSelectChannelNumber;

	if ( m_hVideoDevice[ nChannelNum ] != NULL ) 
	{	
		CString strBmp; strBmp.Format( "unname%d.bmp", nChannelNum );

		CString strFullPathName = GetWorkingPath( strBmp );		
		
		ULONG nStrlen = strFullPathName.GetLength();

		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

        QCAP_SNAPSHOT_BMP( m_hVideoDevice[ nChannelNum ], psz );

		strFullPathName.ReleaseBuffer();
	}

	return TRUE;
}

BOOL CSC510Dlg::OnButtonSnapshotJPG_SetupDialog() 
{
	ULONG nChannelNum = m_nCurSelectChannelNumber;

	if ( m_hVideoDevice[ nChannelNum ] != NULL ) 
	{	
		CString strJpg; strJpg.Format( "unname%d.jpg", nChannelNum );

		CString strFullPathName = GetWorkingPath( strJpg );		
		
		ULONG nStrlen = strFullPathName.GetLength();

		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

        QCAP_SNAPSHOT_JPG( m_hVideoDevice[ nChannelNum ], psz, 100 );

		strFullPathName.ReleaseBuffer();
	}

	return TRUE;
}

BOOL CSC510Dlg::OnButtonVideoInput_SetupDialog() 
{	
	// TODO: Add your control notification handler code here

	ULONG nChannelNum = m_nCurSelectChannelNumber;

	if ( m_hVideoDevice[ nChannelNum ] == NULL ) { return FALSE; }

	CVideoInputDlg dlg;

	INT_PTR nResponse = -1;
	
	nResponse = dlg.DoModal();

	return TRUE;
}

BOOL CSC510Dlg::OnButtonAudioInput_SetupDialog() 
{
	// TODO: Add your control notification handler code here

	ULONG nChannelNum = m_nCurSelectChannelNumber;

	if ( m_hVideoDevice[ nChannelNum ] == NULL ) { return FALSE; }

	CAduioInputDlg dlg(this);

	INT_PTR nResponse = -1;
	
	nResponse = dlg.DoModal();

	return TRUE;
}

BOOL CSC510Dlg::OnButtonVideoQuality_SetupDialog() 
{
	// TODO: Add your control notification handler code here

	ULONG nChannelNum = m_nCurSelectChannelNumber;
	
	if ( m_hVideoDevice[ nChannelNum ] == NULL ) { return FALSE; }

	CVideoQualityDlg dlg(this);

	INT_PTR nResponse = -1;

	nResponse = dlg.DoModal();

	return TRUE;
}

BOOL CSC510Dlg::OnCheckAutoDeinterlace_SetupDialog() 
{
	// TODO: Add your control notification handler code here

	if ( m_oSetupDialog.m_checkAutoDeinterlace.GetCheck() == TRUE ) 
	{
		m_bVideoDeinterlaceEnable = TRUE;
	}
	else 
	{
		m_bVideoDeinterlaceEnable = FALSE;
	}

	for ( ULONG i = 0; i < DEFAULT_MAX_CHANNEL_NUM ; i++ ) 
	{
		if ( m_hVideoDevice[ i ] != NULL ) 
		{
			if ( m_bVideoDeinterlaceEnable ) 
			{
				QCAP_SET_VIDEO_DEINTERLACE( m_hVideoDevice[ i ], TRUE );
			}		
			else 
			{
				QCAP_SET_VIDEO_DEINTERLACE( m_hVideoDevice[ i ], FALSE );
			}        
		}
	}

	return TRUE;
}

BOOL CSC510Dlg::OnCheckShowCloneVideo_SetupDialog()
{
	if ( m_oSetupDialog.m_btnShowCloneVideo.GetCheck() == TRUE ) 
	{
		for ( ULONG i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++ ) 
		{
			m_oChannelWindows_LIVE[ i ].SetParent( CWnd::GetDesktopWindow() );

			m_oChannelWindows_BK[ i ].SetParent( CWnd::GetDesktopWindow() );

			m_oCloneWindows[ i ].SetParent( CWnd::GetDesktopWindow() );

			m_oChannelWindows_LIVE[ i ].SetParent( this );

			m_oChannelWindows_BK[ i ].SetParent( this );

			m_oCloneWindows[ i ].SetParent( this );
			
			// FULL TO SPLIT SCREEN
			//
			if ( !m_nWndState ) 
			{
				m_oCloneWindows[ i ].ShowWindow( TRUE );
			}
			else 
			{				
				if ( i == m_nCurSelectChannelNumber ) { m_oCloneWindows[ i ].ShowWindow( TRUE ); }
			}			

			if ( m_hVideoDevice[ i ] != NULL ) 
			{				
				QCAP_CREATE_CLONE( m_hVideoDevice[ i ], m_oCloneWindows[ i ].GetSafeHwnd(), &m_hCloneCapDev[ i ] );

				if ( m_hCloneCapDev[ i ] != NULL ) 
				{
					QCAP_RUN( m_hCloneCapDev[ i ] );

					QCAP_SET_AUDIO_VOLUME( m_hCloneCapDev[ i ], 0 );
				}
			}		
		}
	}
	else 
	{
		for ( ULONG i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++ ) 
		{
			m_oCloneWindows[ i ].ShowWindow( FALSE );

			if ( m_hCloneCapDev[ i ] != NULL ) 
			{
				QCAP_STOP( m_hCloneCapDev[ i ] );

				QCAP_DESTROY( m_hCloneCapDev[ i ] );

				m_hCloneCapDev[ i ] = NULL;
			}
		}
	}    

	return TRUE;
}

void CSC510Dlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CWnd::OnLButtonDown(nFlags, point);	
	
	PostMessage( WM_NCLBUTTONDOWN, HTCAPTION, MAKELPARAM( point.x, point.y ) );
}

void CSC510Dlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	if ( nIDEvent == 0x00000001 ) 
	{			
		for ( ULONG i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++ ) 
		{			
			if ( m_hVideoDevice[ i ] == NULL ) 
			{ 
				continue ; 
			}
			else 
			{
				if ( i == 0 ) 
				{
					if ( m_bIsRecord1_1 && m_bNoSignal[ i ] ) 
					{
						QCAP_STOP_RECORD( m_hVideoDevice[ i ], 0 );

						m_bIsRecord1_1 = FALSE;
					}
				}

				if ( i == 1 ) 
				{
					if ( m_bIsRecord2_1 && m_bNoSignal[ i ] ) 
					{
						QCAP_STOP_RECORD( m_hVideoDevice[ i ], 0 );

						m_bIsRecord2_1 = FALSE;
					}
				}

				if ( i == 2 ) 
				{
					if ( m_bIsRecord3_1 && m_bNoSignal[ i ] ) 
					{
						QCAP_STOP_RECORD( m_hVideoDevice[ i ], 0 );

						m_bIsRecord3_1 = FALSE;
					}
				}

				if ( i == 3 ) 
				{
					if ( m_bIsRecord3_1 && m_bNoSignal[ i ] ) 
					{
						QCAP_STOP_RECORD( m_hVideoDevice[ i ], 0 );

						m_bIsRecord3_1 = FALSE;
					}
				}
			}
		}
	}

	// TO CONTROL WHETHER THE SIGNAL OF EACH CHNNAEL IS OR ISN'T
	//
	if( nIDEvent == 0x00000002 ) 
	{
		if ( !m_nWndState ) 
		{ 
			for ( ULONG i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++ ) 
			{
				if ( m_bNoSignal[ i ] ) 
				{				
					if ( i == 0 ) { m_oSetupDialog.m_editDeviceFormatInformation_1.SetWindowText( _T("INFO :...") ); }

					if ( i == 1 ) { m_oSetupDialog.m_editDeviceFormatInformation_2.SetWindowText( _T("INFO :...") ); }

					if ( i == 2 ) { m_oSetupDialog.m_editDeviceFormatInformation_3.SetWindowText( _T("INFO :...") ); }

					if ( i == 3 ) { m_oSetupDialog.m_editDeviceFormatInformation_4.SetWindowText( _T("INFO :...") ); }

					m_oChannelWindows_LIVE[ i ].ShowWindow( FALSE );

					m_oChannelWindows_BK[ i ].ShowWindow( TRUE );
				}
				else 
				{
					if ( i == 0 ) { m_oSetupDialog.m_editDeviceFormatInformation_1.SetWindowText( (LPCTSTR)m_strFormatChangedOutput[ 0 ] ); }

					if ( i == 1 ) { m_oSetupDialog.m_editDeviceFormatInformation_2.SetWindowText( (LPCTSTR)m_strFormatChangedOutput[ 1 ] ); }

					if ( i == 2 ) { m_oSetupDialog.m_editDeviceFormatInformation_3.SetWindowText( (LPCTSTR)m_strFormatChangedOutput[ 2 ] ); }

					if ( i == 3 ) { m_oSetupDialog.m_editDeviceFormatInformation_4.SetWindowText( (LPCTSTR)m_strFormatChangedOutput[ 3 ] ); }

					m_oChannelWindows_LIVE[ i ].ShowWindow( TRUE );

					m_oChannelWindows_BK[ i ].ShowWindow( FALSE );			
				}	
			}
		}
	}

	CDialog::OnTimer(nIDEvent);
}

BOOL CSC510Dlg::HwUninitialize()
{	
	for ( ULONG i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++ ) 
	{
		if ( m_hCloneCapDev[ i ] != NULL ) 
		{
			QCAP_STOP( m_hCloneCapDev[ i ] );

			QCAP_DESTROY( m_hCloneCapDev[ i ] );

			m_hCloneCapDev[ i ] = NULL;
		}
		
		if ( m_hVideoDevice[ i ] != NULL ) 
		{
			QCAP_STOP( m_hVideoDevice[ i ] );

			QCAP_DESTROY( m_hVideoDevice[ i ] );

			m_hVideoDevice[ i ] = NULL;
		}
	}

	return TRUE;
}

BOOL CSC510Dlg::HwInitialize()
{
	// CALLBACK FUNCTION
	//        
	PF_FORMAT_CHANGED_CALLBACK m_pFormatChangedCB[ 4 ] = { 0 };

	PF_VIDEO_PREVIEW_CALLBACK  m_pPreviewVideoCB[ 4 ] = { 0 };

	PF_AUDIO_PREVIEW_CALLBACK m_pPreviewAudioCB[ 4 ] = { 0 };
   
	PF_NO_SIGNAL_DETECTED_CALLBACK m_pNoSignalDetectedCB[ 4 ] = { 0 };

	PF_SIGNAL_REMOVED_CALLBACK m_pSignalRemovedCB[ 4 ] = { 0 };

	BOOL bIsDeviceRun = FALSE;

	for ( ULONG i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++ ) 
	{
		// CREATE CAPTURE DEVICE
		//
		// QCAP_CREATE( "FH8735 PCI", i, m_oChannelWindows_LIVE[ i ].m_hWnd, &m_hVideoDevice[ i ] );

		QCAP_CREATE( "SA7160 PCI", i, m_oChannelWindows_LIVE[ i ].m_hWnd, &m_hVideoDevice[ i ] );
		
		if ( m_hVideoDevice[ i ] == NULL ) { continue; }

		bIsDeviceRun = TRUE;

		// REGISTER FORMAT CHANGED CALLBACK FUNCTION
		// 
		m_pFormatChangedCB[ i ] = on_process_format_changed;

		QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_hVideoDevice[ i ], m_pFormatChangedCB[ i ], (PVOID)i );

		// REGISTER PREVIEW VIDEO CALLBACK FUNCTION
		// 
		m_pPreviewVideoCB[ i ] = on_process_preview_video_buffer;

		QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_hVideoDevice[ i ], m_pPreviewVideoCB[ i ], (PVOID)i );

		// REGISTER PREVIEW AUDIO CALLBACK FUNCTION
		//
		m_pPreviewAudioCB[ i ] = on_process_preview_audio_buffer;

		QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_hVideoDevice[ i ], m_pPreviewAudioCB[ i ], (PVOID)i );
		
		// REGISTER NO SIGNAL DETECTED CALLBACK FUNCTION
		//
		m_pNoSignalDetectedCB[ i ] = on_process_no_signal_detected;

		QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_hVideoDevice[ i ], m_pNoSignalDetectedCB[ i ], (PVOID)i );

		// REGISTER SIGNAL REMOVED CALLBACK FUNCTION
		//
		m_pSignalRemovedCB[ i ] =  on_process_signal_removed;

		QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_hVideoDevice[ i ], m_pSignalRemovedCB[ i ], (PVOID)i );

		QCAP_SET_VIDEO_DEINTERLACE( m_hVideoDevice[ i ], FALSE );

		QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ i ], 0 );

	    QCAP_SET_VIDEO_INPUT( m_hVideoDevice[ i ], 0x00000006 ); // SDI				
	}
  
	for ( ULONG i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++ ) 
	{
		QCAP_RUN( m_hVideoDevice[ i ] );
	}

	SetTimer( 0x00000001, 1000, NULL );

	SetTimer( 0x00000002, 1000, NULL );

	// UPDATE USER INTERFACE RESOURCE
	//
	if ( bIsDeviceRun ) 
	{ 
		m_oSetupDialog.m_btnVideoInput.EnableWindow( FALSE );

		m_oSetupDialog.m_btnVideoQuality.EnableWindow( FALSE );

		m_oSetupDialog.m_btnAudioInput.EnableWindow( FALSE );
				
		m_oSetupDialog.m_btnSnapshot_bmp.EnableWindow( FALSE ); 

		m_oSetupDialog.m_btnSnapshot_jpg.EnableWindow( FALSE);

		m_oSetupDialog.m_btnShowCloneVideo.EnableWindow( TRUE );

		m_oSetupDialog.m_checkAutoDeinterlace.EnableWindow( TRUE ); 

		m_oSetupDialog.m_checkAutoDeinterlace.SetCheck( 0 );
	}
	else 
	{
		m_oSetupDialog.m_btnVideoInput.EnableWindow( FALSE );

		m_oSetupDialog.m_btnVideoQuality.EnableWindow( FALSE );

		m_oSetupDialog.m_btnAudioInput.EnableWindow( FALSE );
			
		m_oSetupDialog.m_btnSnapshot_bmp.EnableWindow( FALSE ); 

		m_oSetupDialog.m_btnSnapshot_jpg.EnableWindow( FALSE ); 

		m_oSetupDialog.m_btnShowCloneVideo.EnableWindow( TRUE );

		m_oSetupDialog.m_checkAutoDeinterlace.EnableWindow( TRUE ); 

		m_oSetupDialog.m_checkAutoDeinterlace.SetCheck( 0 );
	}	

	return TRUE;
}