// MySwEncodeAV.cpp: implementation of the MySwEncodeAV class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MySwEncodeAV.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern UINT g_nInetlEncoderCount;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

MySwEncodeAV::MySwEncodeAV()
{
	m_hVideoEncoderDev				= 0xFFFFFFFF;	

	m_nChannelID					= 0;	

	m_nFrameWidth					= 352;

	m_nFrameHeight					= 240;

	m_nCameraType					= 0x00000001;

	m_nColorSpaceType				= MAKEFOURCC('H', '2', '6', '4');

	m_nBitCount						= 24;

	m_dFrameRate					= 29.97;

	m_nRecordMode					= 0;

	m_nQuality_VBR					= 6000;

	m_nQuality_HBR					= 6000;

	m_nBitRateKB_CBR				= 4194304;

	m_nBitRateKB_HBR				= 4194304;

	m_nQPStep_CBR					= 1;

	m_nQPStep_HBR					= 1;

	m_nThroughQualityHBR			= 5000;

	m_nPeakBitRateHBR				= 6291456;

	m_nGOP							= 30;

	m_bUseIntel						= FALSE;
}

MySwEncodeAV::~MySwEncodeAV()
{
	Disconnect();
}

BOOL MySwEncodeAV::Connect()
{
	if (IsConnected() == TRUE) { return TRUE; }		

	USES_CONVERSION;	

	m_hVideoEncoderDev = 0xFFFFFFFF;

	if ( m_bUseIntel && ( g_nInetlEncoderCount != 0 ) )
	{
		if ( m_nChannelID <= g_nInetlEncoderCount )
		{			
			// CREATE VIDEO INTEL SOFTWARE-COMPRESSED DEVICE
			//
			m_hVideoEncoderDev = AMESDK_CREATE( "Common Analog Intel Encoder (H.264)", (m_nChannelID - 1), 7, NULL, NULL, NULL );
		}
		else
		{
			// CREATE VIDEO SOFTWARE-COMPRESSED DEVICE
			//
			//m_hVideoEncoderDev = AMESDK_CREATE( "Common Analog Encoder (H.264)", (m_nChannelID - 1), 7, NULL, NULL, NULL );	

			// ONLY USE INTEL CODEC
			// 
			m_hVideoEncoderDev = 0xFFFFFFFF;
	
			m_bConnect = FALSE;
	
			return m_bConnect;
		}
	}
	else
	{
		m_hVideoEncoderDev = AMESDK_CREATE( "Common Analog Encoder (H.264)", (m_nChannelID - 1), 7, NULL, NULL, NULL );	
	}
	
	if( m_hVideoEncoderDev & 0x80000000 ) 
	{ 
		m_hVideoEncoderDev = 0xFFFFFFFF;
	
		m_bConnect = FALSE;
	
		return m_bConnect;
	}	

	m_bConnect = TRUE;

	return m_bConnect;
}

BOOL MySwEncodeAV::Disconnect()
{
    if (IsConnected() == FALSE)  {  return FALSE;  }	

	if( m_hVideoEncoderDev != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoEncoderDev ); m_hVideoEncoderDev = 0xFFFFFFFF; }

	m_bConnect = FALSE;

	return m_bConnect;
}

BOOL MySwEncodeAV::SetEncodeVideoFormat( ULONG nColorSpaceType, ULONG nCameraType, ULONG nWidth, ULONG nHeight, ULONG nBitCount, DOUBLE dFrameRate)
{
	m_nColorSpaceType = nColorSpaceType;

	m_nCameraType	  = nCameraType;

	m_nFrameWidth	  = nWidth;

	m_nFrameHeight    = nHeight;

	m_nBitCount		  = nBitCount;

	m_dFrameRate      = dFrameRate;

	return TRUE;
}

BOOL MySwEncodeAV::SetEncodeCBR( ULONG iBitRateKB, ULONG iQPStep, ULONG iGOP )
{
	m_nRecordMode	 = 0;

	m_nBitRateKB_CBR = iBitRateKB * 1024;

	m_nQPStep_CBR	 = iQPStep;

	m_nGOP			 = iGOP;

	return TRUE;
}

BOOL MySwEncodeAV::SetEncodeVBR( ULONG iQuality, ULONG iGOP )
{
	m_nRecordMode  = 1;

	m_nQuality_VBR = iQuality;

	m_nGOP		   = iGOP;

	return TRUE;
}

BOOL MySwEncodeAV::SetEncodeHBR( ULONG iQuality, ULONG iBitRateKB, ULONG iQPStep, ULONG iGOP, ULONG iThroughQuality, ULONG iPeakBitRate )
{
	m_nRecordMode			= 3;

	m_nQuality_HBR			= iQuality;

	m_nBitRateKB_HBR		= iBitRateKB * 1024;

	m_nQPStep_HBR			= iQPStep;

	m_nGOP					= iGOP;

	m_nThroughQualityHBR	= iThroughQuality;

	m_nPeakBitRateHBR		= iPeakBitRate;

	return TRUE;
}

BOOL MySwEncodeAV::SetEncodeRun()
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bSet = FALSE;		

	bSet = AMESDK_SET_FORMAT( m_hVideoEncoderDev, 
		
							  MAKEFOURCC('H', '2', '6', '4'), 
							  
							  m_nFrameWidth, 
							  
							  m_nFrameHeight, 
							  
							  24, 
							  
							  m_dFrameRate, 
							  
							  m_nRecordMode, 
							  
							  m_nBitRateKB_CBR, 
							  
							  m_nQuality_VBR, 
							  
							  m_nGOP, 
							  
							 0, 0, 0 ); 

	if ( !bSet ) { return FALSE; }	

	bSet = AMESDK_RUN( m_hVideoEncoderDev );
	
	return bSet;
}

BOOL MySwEncodeAV::SetEncodeStop()
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bSet = FALSE;

	bSet = AMESDK_STOP( m_hVideoEncoderDev );	

	return bSet;
}

BOOL MySwEncodeAV::SetEncodePause()
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bSet = FALSE;

	bSet = AMESDK_PAUSE( m_hVideoEncoderDev );	

	return bSet;
}
