// StreamCatcherDemoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "StreamCatcherDemo.h"
#include "StreamCatcherDemoDlg.h"
#include "VideoInputDlg.h"
#include "AduioInputDlg.h"

#define COMPILE_MULTIMON_STUBS

#include <MULTIMON.H>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[SC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

extern ULONG g_n_init_device_number;

DWORD WINAPI on_device_initialize_thread( LPVOID params )
{
	CStreamCatcherDemoDlg * pStreamCatcherDlg = (CStreamCatcherDemoDlg *)(params);

	ULONG cx = pStreamCatcherDlg->m_nVideoWidth;
	
	ULONG cy = pStreamCatcherDlg->m_nVideoHeight;

	ULONG fps = pStreamCatcherDlg->m_nVideoFrameRate;

	AMESDK_SET_VOLUME( pStreamCatcherDlg->m_hVideoDevice, 0 );

	AMESDK_STOP( pStreamCatcherDlg->m_hVideoDevice );

	AMESDK_STOP( pStreamCatcherDlg->m_hAudioDevice );

	// SETUP STANDARD & FORMAT
	// 
	if( fps == 85 ||

		fps == 75 ||

		fps == 60 ||

		fps == 30 ) { // 85.000 / 75.000 / 60.000 / 30.000

		double _fps = (fps >= 60) ? 59.940 : 29.970;

		ULONG    cs = MAKEFOURCC('Y', 'U', 'Y', '2');

		ULONG  bits = 16;

		AMESDK_SET_STANDARD( pStreamCatcherDlg->m_hVideoDevice, 0x00000001 );

		AMESDK_SET_FORMAT( pStreamCatcherDlg->m_hVideoDevice, cs, pStreamCatcherDlg->m_nVideoWidth, pStreamCatcherDlg->m_nVideoHeight, bits, _fps );

		AMESDK_SET_FORMAT( pStreamCatcherDlg->m_hAudioDevice, pStreamCatcherDlg->m_nAudioChannels, pStreamCatcherDlg->m_nAudioBitsPerSample, pStreamCatcherDlg->m_nAudioSampleFrequency );
	}
	else { // 50.000 / 25.000 / 24.000

		double _fps = (fps == 50) ? 50.000 : 25.000;

		ULONG    cs = MAKEFOURCC('Y', 'U', 'Y', '2');

		ULONG  bits = 16;

		AMESDK_SET_STANDARD( pStreamCatcherDlg->m_hVideoDevice, 0x00000010 );

		AMESDK_SET_FORMAT( pStreamCatcherDlg->m_hVideoDevice, cs, pStreamCatcherDlg->m_nVideoWidth, pStreamCatcherDlg->m_nVideoHeight, bits, _fps );

		AMESDK_SET_FORMAT( pStreamCatcherDlg->m_hAudioDevice, pStreamCatcherDlg->m_nAudioChannels, pStreamCatcherDlg->m_nAudioBitsPerSample, pStreamCatcherDlg->m_nAudioSampleFrequency );
	}

	// SOFTWARE COMPRESSION
	//
	ULONG bitrate = 15 * 1024 * 1024; // FOR CBR, DEFAULT BITRATE = 15MBPS

	ULONG quality = 8000; // FOR VBR, DEFAULT QUALITY = 80%

	ULONG gop = 60; // GOP

	ULONG rc = 1; // RECORD MODE: 0 = VBR / 1 = CBR

	if( pStreamCatcherDlg->m_hVideoSoftwareEncoderDevice != 0xFFFFFFFF ) { // RESET

		AMESDK_DESTROY( pStreamCatcherDlg->m_hVideoSoftwareEncoderDevice );

		pStreamCatcherDlg->m_hVideoSoftwareEncoderDevice = 0xFFFFFFFF;
	}
	if( pStreamCatcherDlg->m_oSetupDialog.m_checkGPU.GetCheck() ) {

		pStreamCatcherDlg->m_hVideoSoftwareEncoderDevice = AMESDK_CREATE( "Common Analog Intel Encoder (H.264)", 0, 7, NULL, NULL, NULL ); // INTEL GPU SUPPOT

		if( pStreamCatcherDlg->m_hVideoSoftwareEncoderDevice & 0x80000000 ) {

			pStreamCatcherDlg->m_hVideoSoftwareEncoderDevice = 0xFFFFFFFF;
		}
		AMESDK_SET_FORMAT( pStreamCatcherDlg->m_hVideoSoftwareEncoderDevice, MAKEFOURCC('H', '2', '6', '4'), cx, cy, 24, fps, rc, bitrate, quality, gop, 0, 0x00000000, 0x00000007 /*BEST QUALITY*/ );
	}
	else {

		pStreamCatcherDlg->m_hVideoSoftwareEncoderDevice = AMESDK_CREATE( "Common Analog Encoder (H.264)", 0, 7, NULL, NULL, NULL ); // CPU ENCORDING

		if( pStreamCatcherDlg->m_hVideoSoftwareEncoderDevice & 0x80000000 ) {

			pStreamCatcherDlg->m_hVideoSoftwareEncoderDevice = 0xFFFFFFFF;
		}
		AMESDK_SET_FORMAT( pStreamCatcherDlg->m_hVideoSoftwareEncoderDevice, MAKEFOURCC('H', '2', '6', '4'), cx, cy, 24, fps, rc, bitrate, quality, gop, 0, 0x00000000, 0x00000001 /*BEST SPEED*/ | 0x80000000 /*MULTI-THREADING*/ );
	}

	// SOFTWARE DEINTERLACE
	//
	if( pStreamCatcherDlg->m_hVideoSoftwareDeinterlacerDevice != 0xFFFFFFFF ) { // RESET

		AMESDK_DESTROY( pStreamCatcherDlg->m_hVideoSoftwareDeinterlacerDevice );

		pStreamCatcherDlg->m_hVideoSoftwareDeinterlacerDevice = 0xFFFFFFFF;
	}
	pStreamCatcherDlg->m_hVideoSoftwareDeinterlacerDevice = AMESDK_CREATE( "Common Analog Deinterlacer", 0, 16, NULL, NULL, NULL );

	if( pStreamCatcherDlg->m_hVideoSoftwareDeinterlacerDevice & 0x80000000 ) {

		pStreamCatcherDlg->m_hVideoSoftwareDeinterlacerDevice = 0xFFFFFFFF;
	}
	AMESDK_SET_FORMAT( pStreamCatcherDlg->m_hVideoSoftwareDeinterlacerDevice, MAKEFOURCC('Y', 'U', 'Y', '2'), cx, cy, 12, fps );

	// RUN
	//
	AMESDK_RUN( pStreamCatcherDlg->m_hVideoDevice ); 
	
	AMESDK_RUN( pStreamCatcherDlg->m_hAudioDevice ); 

	AMESDK_SET_VOLUME( pStreamCatcherDlg->m_hAudioDevice, 100 );

	// FINAL
	//
	pStreamCatcherDlg->m_hDeviceInitializeThreadNumber = 0x00000000;

	pStreamCatcherDlg->m_hDeviceInitializeThread = NULL;

	return TRUE;
}

BOOL on_process_video_buffer( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	CStreamCatcherDemoDlg * pStreamCatcherDlg = (CStreamCatcherDemoDlg *)(pUserData);

	BYTE *					pStreamBuffer = NULL;

	ULONG					nStreamBufferLen = 0;

	ULONG					cx = pStreamCatcherDlg->m_nVideoWidth;

	ULONG					cy = pStreamCatcherDlg->m_nVideoHeight;

	if( pStreamCatcherDlg->m_bVideoIsInterleaved ) {

		AMESDK_DI_DEINTERLACE( pStreamCatcherDlg->m_hVideoSoftwareDeinterlacerDevice, pBuffer, nBufferLen );
	}
	else {

		;
	}

	// ON.RESET.ENCODER
	//
	EnterCriticalSection( &pStreamCatcherDlg->m_hFileRendererAccessCriticalSection );

	if( pStreamCatcherDlg->m_nRecordState == 0x00000001 ) { // QUERY.KEY.FRAME

		pStreamCatcherDlg->m_nRecordState = 0x00000003;

		LeaveCriticalSection( &pStreamCatcherDlg->m_hFileRendererAccessCriticalSection );

		AMESDK_PAUSE( pStreamCatcherDlg->m_hVideoSoftwareEncoderDevice );

		AMESDK_RUN( pStreamCatcherDlg->m_hVideoSoftwareEncoderDevice );
	}
	else {

		LeaveCriticalSection( &pStreamCatcherDlg->m_hFileRendererAccessCriticalSection );
	}

	// ON.ENCODE
	//
	EnterCriticalSection( &pStreamCatcherDlg->m_hFileRendererAccessCriticalSection );

	if( pStreamCatcherDlg->m_nRecordState >= 0x00000003 ) {

		LeaveCriticalSection( &pStreamCatcherDlg->m_hFileRendererAccessCriticalSection );

		AMESDK_RUN( pStreamCatcherDlg->m_hVideoSoftwareEncoderDevice );

		AMESDK_CODEC_ENCODE( pStreamCatcherDlg->m_hVideoSoftwareEncoderDevice, pBuffer, MAKEFOURCC('Y', 'U', 'Y', '2'), cx, cy, &pStreamBuffer, &nStreamBufferLen, &bIsKeyFrame );
	}
	else {

		LeaveCriticalSection( &pStreamCatcherDlg->m_hFileRendererAccessCriticalSection );
	}

	// ON.RECORD
	// 
	EnterCriticalSection( &pStreamCatcherDlg->m_hFileRendererAccessCriticalSection );

	if( pStreamCatcherDlg->m_nRecordState >= 0x00000003 ) { // QUERY.KEY.FRAME

		if( nStreamBufferLen > 0 ) {

			AMESDK_FILE_SET_VIDEO_STREAM_BUFFER( pStreamCatcherDlg->m_hDevFileRenderer, pStreamBuffer, nStreamBufferLen, bIsKeyFrame );
		}
	}
	LeaveCriticalSection( &pStreamCatcherDlg->m_hFileRendererAccessCriticalSection );

	return TRUE;
}

BOOL on_process_audio_buffer( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	CStreamCatcherDemoDlg * pStreamCatcherDlg = (CStreamCatcherDemoDlg *)(pUserData);

	// ON.RECORD
	//
	EnterCriticalSection( &pStreamCatcherDlg->m_hFileRendererAccessCriticalSection );

	if( pStreamCatcherDlg->m_nRecordState >= 0x00000003 ) {

		AMESDK_FILE_SET_AUDIO_STREAM_BUFFER( pStreamCatcherDlg->m_hDevFileRenderer, pBuffer, nBufferLen );
	}
	LeaveCriticalSection( &pStreamCatcherDlg->m_hFileRendererAccessCriticalSection );

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CStreamCatcherDemoDlg dialog

CStreamCatcherDemoDlg::CStreamCatcherDemoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CStreamCatcherDemoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CStreamCatcherDemoDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CStreamCatcherDemoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CStreamCatcherDemoDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CStreamCatcherDemoDlg, CDialog)
	//{{AFX_MSG_MAP(CStreamCatcherDemoDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_WM_ERASEBKGND()
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStreamCatcherDemoDlg message handlers

BOOL CStreamCatcherDemoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] INITIALIZE MEMBER VARIABLES
	//
	{	m_hDeviceInitializeThread = NULL;

		m_hDeviceInitializeThreadNumber = 0x00000000;

		m_hVideoDevice = 0xFFFFFFFF;

		m_hVideoSoftwareEncoderDevice = 0xFFFFFFFF;

		m_hVideoSoftwareDeinterlacerDevice = 0xFFFFFFFF;

		m_nVideoWidth = 0;

		m_nVideoHeight = 0;

		m_bVideoIsInterleaved = FALSE;

		m_nVideoFrameRate = 0;

		m_hAudioDevice = 0xFFFFFFFF;

		m_nAudioChannels = 0;

		m_nAudioBitsPerSample = 0;

		m_nAudioSampleFrequency = 0;

		// GET DEFAULT RECORD PATH
		// 
		{	BYTE pData[ MAX_PATH ]; DWORD dwType = REG_SZ; DWORD dwData = MAX_PATH;

			HKEY hKey = NULL; RegOpenKey( HKEY_CURRENT_USER, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", &hKey );

			RegQueryValueEx( hKey, "Personal", NULL, &dwType, pData, &dwData );

			RegCloseKey( hKey );

			CHAR psz[ MAX_PATH ] = "";

			if( strlen( (CHAR *)(pData) ) ) {

				m_strDefaultPath.Format( "%s", (CHAR *)(pData) );
			}
			else {

				m_strDefaultPath.Format( "%s", "" );
			}
			m_strRecordPath.Format( "%s\\My Records", m_strDefaultPath );

			CreateDirectory( m_strRecordPath, NULL );
		}
		m_strRecordFileName = "";

		m_nRecordState = 0x00000000;

		m_hDevFileRenderer = 0xFFFFFFFF;

		InitializeCriticalSection( &m_hFileRendererAccessCriticalSection );
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] INITIALIZE COM RESOURCE
	//
	{	HRESULT hr = CoInitialize( NULL );
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] INITIALIZE USER INTERFACE RESOURCE
	//
	{	m_oChannelWindows[ 1 ].Create( NULL, "MyChannelWindow#01", WS_CHILD | WS_VISIBLE, CRect( 0, 0, 960, 540 ), this, 0x00000001, NULL ); // BACKGROUND WINDOW

		m_oChannelWindows[ 0 ].Create( NULL, "MyChannelWindow#02", WS_CHILD | WS_VISIBLE, CRect( 0, 0, 960, 540 ), this, 0x00000002, NULL ); // VIDEO WINDOW

		// INITIALIZE MAIN WINDOW
		//
		{	CRect oWindowRect; GetWindowRect( &oWindowRect );

			CRect oClientRect; GetClientRect( &oClientRect );

			ULONG cx = oWindowRect.Width() - oClientRect.Width(); // GET DEFAULT BOUNDARY WIDTH OF DIALOG

			ULONG cy = oWindowRect.Height() - oClientRect.Height(); // GET DEFAULT BOUNDARY HEIGHT OF DIALOG

			MoveWindow( 0, 0, cx + 960, cy + 540 );
		}

		// INITIALIZE SETUP DIALOG
		//
		{	HMONITOR hMonitor = MonitorFromWindow( m_hWnd, MONITOR_DEFAULTTONEAREST );	

			MONITORINFO sMonitorInfo = { sizeof(MONITORINFO), }; 
			
			GetMonitorInfo( hMonitor, &sMonitorInfo );

			CRect oMonitorRect = sMonitorInfo.rcWork;
			
			m_oSetupDialog.Create( IDD_SETUP_DIALOG, this );

			CRect oWindowRect; m_oSetupDialog.GetWindowRect( &oWindowRect );

			CRect oClientRect; m_oSetupDialog.GetClientRect( &oClientRect );

			ULONG cx = oWindowRect.Width() - oClientRect.Width(); // GET DEFAULT BOUNDARY WIDTH OF DIALOG

			ULONG cy = oWindowRect.Height() - oClientRect.Height(); // GET DEFAULT BOUNDARY HEIGHT OF DIALOG

			m_oSetupDialog.SetWindowPos( &(CWnd::wndTop), (oMonitorRect.Width() - (960 + cx)) / 2,

														  (oMonitorRect.Height() - (105 + 40 + cy)),
														  
														  (cx + 960), 
														  
														  (cy + 105), 
														  
														  (NULL) );
			m_oSetupDialog.ShowWindow( TRUE );
		}
		SetWindowText( "" DEFAULT_PRODUCT ", " DEFAULT_PRODUCT_VERSION );

		SetTimer( 0x00000000, 0, NULL );
	}
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CStreamCatcherDemoDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here

	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE DEVICE RESOURCE
	//
	{	HwUninitialize();
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE USER INTERFACE RESOURCE
	//
	{	m_oChannelWindows[ 0 ].DestroyWindow();

		m_oChannelWindows[ 1 ].DestroyWindow();

		m_oSetupDialog.DestroyWindow();
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE COM RESOURCE
	//
	{	CoUninitialize();
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE MEMBER VARIABLES
	//
	{	DeleteCriticalSection( &m_hFileRendererAccessCriticalSection );
	}
}

BOOL CStreamCatcherDemoDlg::HwUninitialize()
{
	CLOSE_THREAD( m_hDeviceInitializeThread );

	if( m_hVideoDevice != 0xFFFFFFFF ) {

		AMESDK_STOP( m_hVideoDevice );

		AMESDK_DESTROY( m_hVideoDevice );

		m_hVideoDevice = 0xFFFFFFFF;
	}
	if( m_hAudioDevice != 0xFFFFFFFF ) {

		AMESDK_STOP( m_hAudioDevice );

		AMESDK_DESTROY( m_hAudioDevice );

		m_hAudioDevice = 0xFFFFFFFF;
	}
	if( m_hVideoSoftwareEncoderDevice != 0xFFFFFFFF ) {

		AMESDK_STOP( m_hVideoSoftwareEncoderDevice );

		AMESDK_DESTROY( m_hVideoSoftwareEncoderDevice );

		m_hVideoSoftwareEncoderDevice = 0xFFFFFFFF;
	}
	if( m_hVideoSoftwareDeinterlacerDevice != 0xFFFFFFFF ) {

		AMESDK_STOP( m_hVideoSoftwareDeinterlacerDevice );

		AMESDK_DESTROY( m_hVideoSoftwareDeinterlacerDevice );

		m_hVideoSoftwareDeinterlacerDevice = 0xFFFFFFFF;
	}
	return TRUE;
}

BOOL CStreamCatcherDemoDlg::HwInitialize()
{
	// OS DETECTION
	//
	BOOL is_enable_enhanced_video_renderer = FALSE;

	OSVERSIONINFO s_os_version_info;

	memset( &s_os_version_info, 0x00, sizeof(s_os_version_info) );

	s_os_version_info.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);

	GetVersionEx( &s_os_version_info );

	if( s_os_version_info.dwMajorVersion >= 6 &&

		s_os_version_info.dwMinorVersion >= 1 ) {

		is_enable_enhanced_video_renderer = TRUE;
	}

	// CREATE VIDEO & AUDIO DEVICE
	//
	m_hVideoDevice = AMESDK_CREATE_EX( "SA7160 PCI", g_n_init_device_number, 0, m_oChannelWindows[ 0 ].m_hWnd, on_process_video_buffer, TRUE, FALSE, is_enable_enhanced_video_renderer, this );

	if( m_hVideoDevice & 0x80000000 ) { 
		
		m_hVideoDevice = 0xFFFFFFFF; 
	}
	else {

		m_hAudioDevice = AMESDK_CREATE( "SA7160 PCI, Analog WaveIn", g_n_init_device_number, 0, m_oChannelWindows[ 0 ].m_hWnd, on_process_audio_buffer, this );

		if( m_hAudioDevice & 0x80000000 ) { m_hAudioDevice = 0xFFFFFFFF; }
	}

	// UPDATE USER INTERFACE RESOURCE
	//
	if( m_hVideoDevice == 0xFFFFFFFF ) { m_oSetupDialog.m_btnVideoInput.EnableWindow( FALSE ); }

	if( m_hAudioDevice == 0xFFFFFFFF ) { m_oSetupDialog.m_btnAudioInput.EnableWindow( FALSE ); }

	if( m_hVideoDevice == 0xFFFFFFFF ) { m_oSetupDialog.m_btnVideoQuality.EnableWindow( FALSE ); }

	if( m_hVideoDevice == 0xFFFFFFFF ) { 
		
		m_oSetupDialog.m_btnRecordStart.EnableWindow( FALSE ); 

		m_oSetupDialog.m_btnRecordStop.EnableWindow( FALSE ); 

		m_oSetupDialog.m_checkGPU.EnableWindow( FALSE ); 

		m_oSetupDialog.m_checkGPU.SetCheck( 0 );
	}
	else {
			
		m_oSetupDialog.m_btnRecordStart.EnableWindow( TRUE ); 

		m_oSetupDialog.m_btnRecordStop.EnableWindow( FALSE );

		m_oSetupDialog.m_checkGPU.EnableWindow( TRUE ); 

		m_oSetupDialog.m_checkGPU.SetCheck( 1 );
	}
	return TRUE;
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CStreamCatcherDemoDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CStreamCatcherDemoDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CStreamCatcherDemoDlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

void CStreamCatcherDemoDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

BOOL CStreamCatcherDemoDlg::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default
	
	return CDialog::OnEraseBkgnd(pDC);
}

void CStreamCatcherDemoDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	if( nIDEvent == 0x00000000 ) {

		KillTimer( 0x00000000 );

		HwInitialize();

		SetTimer( 0x00000001, 1000, NULL );
	}
	if( nIDEvent == 0x00000001 ) {

		if( m_hVideoDevice == 0xFFFFFFFF ) { return ; }

		ULONG nVideoWidth = 0x00000000;

		ULONG nVideoHeight = 0x00000000;

		BOOL  bVideoIsInterleaved = FALSE;

		ULONG nVideoFrameRate = 0x00000000;

		ULONG nAudioChannels = 0x00000000;

		ULONG nAudioBitsPerSample = 0x00000000;

		ULONG nAudioSampleFrequency = 0x00000000;

		OnGetDeviceFormatInfomation( &nVideoWidth, &nVideoHeight, &bVideoIsInterleaved, &nVideoFrameRate, &nAudioChannels, &nAudioBitsPerSample, &nAudioSampleFrequency );

		if( nVideoWidth == 0 ||

			nVideoHeight == 0 ||

			nVideoFrameRate == 0 ||

			nAudioChannels == 0 ||

			nAudioBitsPerSample == 0 ||

			nAudioSampleFrequency == 0 ) {

			if( m_nVideoWidth != nVideoWidth || 

				m_nVideoHeight != nVideoHeight || 

				m_nVideoFrameRate != nVideoFrameRate || 

				m_nAudioChannels != nAudioChannels ||

				m_nAudioBitsPerSample != nAudioBitsPerSample ||

				m_nAudioSampleFrequency != nAudioSampleFrequency ) {

				OnButtonRecordStop_SetupDialog();

				CLOSE_THREAD( m_hDeviceInitializeThread );

				AMESDK_STOP( m_hVideoDevice );
				
				AMESDK_STOP( m_hAudioDevice );
			}
			m_nVideoWidth = 0;

			m_nVideoHeight = 0;

			m_bVideoIsInterleaved = FALSE;

			m_nVideoFrameRate = 0;

			m_nAudioChannels = 0;

			m_nAudioBitsPerSample = 0;

			m_nAudioSampleFrequency = 0;

			m_oSetupDialog.m_staticDeviceFormatInformation.SetWindowText( " INFO: . . ." );
		}
		else if( m_nVideoWidth != nVideoWidth || 

				 m_nVideoHeight != nVideoHeight || 

				 m_bVideoIsInterleaved != bVideoIsInterleaved || 

				 m_nVideoFrameRate != nVideoFrameRate || 	
				 
				 m_nAudioChannels != nAudioChannels ||

				 m_nAudioBitsPerSample != nAudioBitsPerSample ||

				 m_nAudioSampleFrequency != nAudioSampleFrequency ) {

			OnButtonRecordStop_SetupDialog();

			CLOSE_THREAD( m_hDeviceInitializeThread );

			AMESDK_STOP( m_hVideoDevice );

			AMESDK_STOP( m_hAudioDevice );

			m_nVideoWidth = nVideoWidth;

			m_nVideoHeight = nVideoHeight;

			m_bVideoIsInterleaved = bVideoIsInterleaved;

			m_nVideoFrameRate = nVideoFrameRate;

			m_nAudioChannels = nAudioChannels;

			m_nAudioBitsPerSample = nAudioBitsPerSample;

			m_nAudioSampleFrequency = nAudioSampleFrequency;

			m_hDeviceInitializeThread = CreateThread( NULL, 0, (LPTHREAD_START_ROUTINE)(on_device_initialize_thread), (LPVOID)(this), 0, &m_hDeviceInitializeThreadNumber );

			CHAR psz[ MAX_PATH ];

			sprintf( psz, " INFO: %d x %d%c @ %dFPS, %dCH x %02dBITS x %dHZ, %s", m_nVideoWidth, 
				
																			     (m_bVideoIsInterleaved) ? (m_nVideoHeight / 2) : (m_nVideoHeight), 
																							
																			     (m_bVideoIsInterleaved) ? ('I') : ('P'),

																				  m_nVideoFrameRate,

																				  m_nAudioChannels, 
																			 
																				  m_nAudioBitsPerSample, 
																			 
																				  m_nAudioSampleFrequency,
																			  
																				  m_strRecordFileName );

			m_oSetupDialog.m_staticDeviceFormatInformation.SetWindowText( psz );
		}
	}
	CDialog::OnTimer(nIDEvent);
}
	
BOOL CStreamCatcherDemoDlg::OnGetDeviceFormatInfomation( ULONG * pVideoWidth, 

														 ULONG * pVideoHeight, 

														 BOOL *  pVideoIsInterleaved, 

														 ULONG * pVideoFrameRate, 
													   
														 ULONG * pAudioChannels, 
														   
														 ULONG * pAudioBitsPerSample, 
													   
														 ULONG * pAudioSampleFrequency )
{
	ULONG dw_video_resolution_property = 0x00000000;

	ULONG dw_video_framerate_property = 0x00000000;

	ULONG dw_audio_sample_frequency_property = 0x00000000;

	if( m_hVideoDevice == 0xFFFFFFFF ) { 

	   *pVideoWidth = 0x00000000; 

	   *pVideoHeight = 0x00000000; 

	   *pVideoIsInterleaved = FALSE; 

	   *pVideoFrameRate = 0x00000000; 

	   *pAudioChannels = 0x00000000;

	   *pAudioBitsPerSample = 0x00000000;

	   *pAudioSampleFrequency = 0x00000000;
	   
	    return TRUE; 
	}
	AMESDK_GET_CUSTOM_PROPERTY( m_hVideoDevice, 208, &dw_video_framerate_property );

	AMESDK_GET_CUSTOM_PROPERTY( m_hVideoDevice, 210, &dw_video_resolution_property );

	AMESDK_GET_CUSTOM_PROPERTY( m_hVideoDevice, 253, &dw_audio_sample_frequency_property );

	if( dw_video_framerate_property == 0 ||

		dw_video_resolution_property == 0 ||

		dw_audio_sample_frequency_property == 0 ) {

		dw_video_framerate_property = 0;

		dw_video_resolution_property = 0;

		dw_audio_sample_frequency_property = 0;
	}
	ULONG cx = 0;

	ULONG cy = 0;

	BOOL interleaved = FALSE;

	cx = (dw_video_resolution_property >> 16) & 0x0000FFFF;

	cy = (dw_video_resolution_property >> 0) & 0x0000FFFF;

	if( (cx ==  720 && cy == 240 && dw_video_framerate_property == 60) ||

		(cx ==  720 && cy == 288 && dw_video_framerate_property == 50) ||

		(cx == 1920 && cy == 540 && dw_video_framerate_property == 60) ||

		(cx == 1920 && cy == 540 && dw_video_framerate_property == 50) ) {

		interleaved = TRUE;

		cy = cy * 2;
	}
	else if( (cx == 1440 && cy == 240 && dw_video_framerate_property == 60) ||

			 (cx == 1440 && cy == 288 && dw_video_framerate_property == 50) ) {

		cx = cx / 2;
	}
	else {

		;
	}
   *pVideoWidth = cx;

   *pVideoHeight = cy;

   *pVideoIsInterleaved = interleaved;

   *pVideoFrameRate = dw_video_framerate_property;

	if( dw_audio_sample_frequency_property == 0 ) {

	   *pAudioChannels = 0;

	   *pAudioBitsPerSample = 0;

	   *pAudioSampleFrequency = dw_audio_sample_frequency_property;

	}
	else {

	   *pAudioChannels = 2;

	   *pAudioBitsPerSample = 16;

	   *pAudioSampleFrequency = dw_audio_sample_frequency_property;
	}
	return TRUE;
}

BOOL CStreamCatcherDemoDlg::OnButtonVideoInput_SetupDialog() 
{
	// TODO: Add your control notification handler code here
	
	if( m_hVideoDevice == 0xFFFFFFFF ) { return FALSE; }

	CVideoInputDlg dlg;

	dlg.DoModal();

	return TRUE;
}

BOOL CStreamCatcherDemoDlg::OnButtonAudioInput_SetupDialog() 
{
	// TODO: Add your control notification handler code here

	if( m_hVideoDevice == 0xFFFFFFFF ) { return FALSE; }

	CAduioInputDlg dlg;

	dlg.DoModal();

	return TRUE;
}

BOOL CStreamCatcherDemoDlg::OnButtonVideoQuality_SetupDialog() 
{
	// TODO: Add your control notification handler code here
	
	AMESDK_GET_VIDEOPROCAMP_PROPERTY_PAGE( m_hVideoDevice, m_hWnd );

	return TRUE;
}

BOOL CStreamCatcherDemoDlg::OnButtonRecordStart_SetupDialog() 
{
	// TODO: Add your control notification handler code here

	EnterCriticalSection( &m_hFileRendererAccessCriticalSection );

	if( m_nRecordState >= 0x00000001 ) {

		OnButtonRecordStop_SetupDialog();
	}
	if( m_nRecordState == 0x00000000 ) {

		// CREATE NEW RECORD FILE
		//
		CHAR psz[ MAX_PATH ];

		SYSTEMTIME system_times; 

		GetLocalTime( &system_times );

		m_strRecordFileName.Format( "%s\\%04d%02d%02d%02d%02d%02d.AVI", m_strRecordPath, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond );
		
		sprintf( psz, "Common Analog File Renderer %s", m_strRecordFileName );

		m_hDevFileRenderer = AMESDK_CREATE( psz, 0, 3, NULL, NULL, NULL );

		if( m_hDevFileRenderer & 0x80000000 ) { 

			m_hDevFileRenderer = 0xFFFFFFFF; 
		}
		AMESDK_FILE_SET_VIDEO_STREAM_FORMAT( m_hDevFileRenderer, MAKEFOURCC('H', '2', '6', '4'), m_nVideoWidth, m_nVideoHeight, 24, m_nVideoFrameRate, AMESDK_FILE_CUSTOMFLAG_NONINDEX | AMESDK_FILE_CUSTOMFLAG_ISSYNCHRONIZATION );

		AMESDK_FILE_SET_AUDIO_STREAM_FORMAT( m_hDevFileRenderer, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency );

		// START RECORDING
		//
		m_nRecordState = 0x00000001;
	}
	LeaveCriticalSection( &m_hFileRendererAccessCriticalSection );

	m_oSetupDialog.m_btnRecordStart.EnableWindow( FALSE ); 

	m_oSetupDialog.m_btnRecordStop.EnableWindow( TRUE );	

	CHAR psz[ MAX_PATH ];

	sprintf( psz, " INFO: %d x %d%c @ %dFPS, %dCH x %02dBITS x %dHZ, %s", m_nVideoWidth, 
		
																		 (m_bVideoIsInterleaved) ? (m_nVideoHeight / 2) : (m_nVideoHeight), 
																					
																		 (m_bVideoIsInterleaved) ? ('I') : ('P'),

																		  m_nVideoFrameRate,

																		  m_nAudioChannels, 
																	 
																		  m_nAudioBitsPerSample, 
																	 
																		  m_nAudioSampleFrequency,
																	  
																		  m_strRecordFileName );
	m_oSetupDialog.m_staticDeviceFormatInformation.SetWindowText( psz );

	return TRUE;
}

BOOL CStreamCatcherDemoDlg::OnButtonRecordStop_SetupDialog() 
{
	// TODO: Add your control notification handler code here
	
	EnterCriticalSection( &m_hFileRendererAccessCriticalSection );

	if( m_nRecordState >= 0x00000001 ) {

		// STOP RECORDING
		//
		m_nRecordState = 0x00000000;

		// CLOSE CURRENT RECORD FILE
		//
		if( m_hDevFileRenderer != 0xFFFFFFFF ) {

			AMESDK_DESTROY( m_hDevFileRenderer ); 

			m_hDevFileRenderer = 0xFFFFFFFF;

			m_strRecordFileName = "";
		}
	}
	LeaveCriticalSection( &m_hFileRendererAccessCriticalSection );

	m_oSetupDialog.m_btnRecordStart.EnableWindow( TRUE ); 

	m_oSetupDialog.m_btnRecordStop.EnableWindow( FALSE ); 	

	CHAR psz[ MAX_PATH ];

	sprintf( psz, " INFO: %d x %d%c @ %dFPS, %dCH x %02dBITS x %dHZ, %s", m_nVideoWidth, 
		
																		 (m_bVideoIsInterleaved) ? (m_nVideoHeight / 2) : (m_nVideoHeight), 
																					
																		 (m_bVideoIsInterleaved) ? ('I') : ('P'),

																		  m_nVideoFrameRate,

																		  m_nAudioChannels, 
																	 
																		  m_nAudioBitsPerSample, 
																	 
																		  m_nAudioSampleFrequency,
																	  
																		  m_strRecordFileName );
	m_oSetupDialog.m_staticDeviceFormatInformation.SetWindowText( psz );

	return TRUE;
}

BOOL CStreamCatcherDemoDlg::OnCheckGpuSupport_SetupDialog() 
{
	// TODO: Add your control notification handler code here

	// RESET SOFTWARE ENCODER
	//
	OnButtonRecordStop_SetupDialog();

	CLOSE_THREAD( m_hDeviceInitializeThread );

	AMESDK_STOP( m_hVideoDevice );

	AMESDK_STOP( m_hAudioDevice );

	m_nVideoWidth = 0;

	m_nVideoHeight = 0;

	m_bVideoIsInterleaved = FALSE;

	m_nVideoFrameRate = 0;

	m_nAudioChannels = 0;

	m_nAudioBitsPerSample = 0;

	m_nAudioSampleFrequency = 0;

	return TRUE;
}

BOOL CStreamCatcherDemoDlg::OnLButtonDblClk_ChannelWindow() 
{
	// TODO: Add your message handler code here and/or call default

	HMONITOR hMonitor = MonitorFromWindow( m_hWnd, MONITOR_DEFAULTTONEAREST );	

	MONITORINFO sMonitorInfo = { sizeof(MONITORINFO), }; 

	GetMonitorInfo( hMonitor, &sMonitorInfo );

	CRect oMonitorRect = sMonitorInfo.rcMonitor;

	CRect oWindowRect; GetWindowRect( &oWindowRect );

	if( oWindowRect.Width() < oMonitorRect.Width() ) {

		m_oChannelWindows[ 0 ].MoveWindow( 0, 0, oMonitorRect.Width(), oMonitorRect.Height() );

		m_oChannelWindows[ 1 ].MoveWindow( 0, 0, oMonitorRect.Width(), oMonitorRect.Height() );

		MoveWindow( oMonitorRect );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDevice );
	}
	else {

		m_oChannelWindows[ 0 ].MoveWindow( 0, 0, 960, 540 );

		m_oChannelWindows[ 1 ].MoveWindow( 0, 0, 960, 540 );

		MoveWindow( (oMonitorRect.Width() - 960) / 2, (oMonitorRect.Height() - 540) / 2, 960, 540 );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDevice );
	}
	return TRUE;
}
