#ifndef SUPERIO_API_H

#define	SUPERIO_API_H



#define	POWER_ON_IGNITION		0xA5

#define	POWER_ON_REMOTE			0x5A



#define	IGNITION_ON				0xA5

#define	IGNITION_OFF			0x5A



#define	GPO_BIT_0				0

#define	GPO_BIT_1				1

#define	GPO_BIT_2				2

#define	GPO_BIT_3				3

#define	GPI_BIT_4				4

#define	GPI_BIT_5				5

#define	GPI_BIT_6				6

#define	GPI_BIT_7				7



#define	CANBUS_BAUDRATE_10K		10

#define	CANBUS_BAUDRATE_20K		20

#define	CANBUS_BAUDRATE_50K		50

#define	CANBUS_BAUDRATE_100K	100

#define	CANBUS_BAUDRATE_125K	125

#define	CANBUS_BAUDRATE_250K	250

#define	CANBUS_BAUDRATE_500K	500

#define	CANBUS_BAUDRATE_800K	800

#define	CANBUS_BAUDRATE_1000K	1000



#define	CANBUS_MSG_ID_11_BITS	0x00

#define	CANBUS_MSG_ID_29_BITS	0x04



#define	FLAG_RTR				0x01

#define FLAG_EXT				0X04



// ---------------------------------------------------------------------------- TYPE DEFINE

//

typedef enum _E_TIME_UNIT {



	TIME_UNIT_SECOND,

	TIME_UNIT_MINUTE,



} E_TIMER_UNIT;



typedef struct _T_PIC_INFO {



	BYTE PicType[ 3 ];

	BYTE PicModel[ 4 ];

	BYTE PicMajorVersion;

	BYTE PicMinorVersion;



} T_PIC_INFO;



typedef struct _T_CANBUS_MSG {



    DWORD	dwFlag;

    DWORD   dwObjectNumber;

    DWORD	dwMsgID;

	DWORD	dwSecond;

    DWORD	dwMicroSecond;

    WORD	wDataLen;

    BYTE	szData[ 8 ]; 



} T_CANBUS_MSG;



// ---------------------------------------------------------------------------- SUPER I/O DRIVER

//

BOOL WINAPI SuperIo_Open();

void WINAPI SuperIo_Close();



// ---------------------------------------------------------------------------- GPIO 

//

BOOL WINAPI Gpio_GetBitValue( int nBit, BYTE* pValue );

BOOL WINAPI Gpio_SetBitValue( int nBit, BYTE  bValue );



// ---------------------------------------------------------------------------- POWER PIC

//

BOOL WINAPI PowerPic_Open();

void WINAPI PowerPic_Close();



BOOL WINAPI PowerPic_SetDefaultValue();



BOOL WINAPI PowerPic_GetPicMode( BYTE* pMode );



BOOL WINAPI PowerPic_GetPowerOnMode( BYTE* pMode );

BOOL WINAPI PowerPic_SetPowerOnMode( BYTE  bMode );



BOOL WINAPI PowerPic_GetHardOffDelayTime( int* pSeconds );

BOOL WINAPI PowerPic_GetSoftOffDelayTime( int* pSeconds );



BOOL WINAPI PowerPic_SetSoftOffDelayTime( int nTime, int nTimeUnit );

BOOL WINAPI PowerPic_SetHardOffDelayTime( int nTime, int nTimeUnit );



BOOL WINAPI PowerPic_GetIgnitionStatus( BYTE* pStatus );

BOOL WINAPI PowerPic_GetBatteryVoltage( float *pVoltage );

BOOL WINAPI PowerPic_GetFirmwareVersion( T_PIC_INFO *pPicInfo );



// ---------------------------------------------------------------------------- WATCHDOG TIMER

//

BOOL WINAPI WatchDog_GetTimerCount( int* pCount );



BOOL WINAPI WatchDog_SetTimerUnit( int  nTimerUnit );

BOOL WINAPI WatchDog_GetTimerUnit( int* pTimerUnit );



BOOL WINAPI WatchDog_StartTimer( int nTimerCount, int nTimerUnit );

BOOL WINAPI WatchDog_StopTimer();



// ---------------------------------------------------------------------------- CAN BUS

//

BOOL WINAPI CanBus_Open();

void WINAPI CanBus_Close();

BOOL WINAPI CanBus_SetBaudrate( int nBaudrate );

BOOL WINAPI CanBus_GetMessage( T_CANBUS_MSG* pMsg );

BOOL WINAPI CanBus_SendMessage( T_CANBUS_MSG* pMsg );



#endif



