// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the NUCLIB_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// NUCLIB_API functions as being imported from a DLL, whereas this DLL sees symbols
// defined with this macro as being exported.
#ifdef NUCLIB_EXPORTS
#define NUCLIB_API __declspec(dllexport)
#else
#define NUCLIB_API __declspec(dllimport)
#endif

#define DCMD_SPI_WRITE_DATA_VOL_VOUT	0x30
#define DCMD_SPI_INC_VOL_WIPER_VOUT		0x32
#define DCMD_SPI_DEC_VOL_WIPER_VOUT		0x33
#define DCMD_RELOAD_PARAMS_ON_FLY		0x03

extern "C" NUCLIB_API const char* STATE_MACHINE[];//state machine 

extern "C" NUCLIB_API unsigned char nucOpenDeviceHandler(unsigned int timer);//open device handler. timer sets the refresh period in miliseconds (4 messages will be sent in this period) IMPORTANT: the handler can be kept open to notice any DCDC-NUC plugged in
extern "C" NUCLIB_API void nucCloseDeviceHandler();//close device handler
extern "C" NUCLIB_API void getNUCDevicePath(char* path);//Get opened device path @param path - recommended length 1024, will return empty string if no device opened

extern "C" NUCLIB_API unsigned char isNUCConnected();//0=not connected, 1=normal state,2=loading settings from device,3=saving settings from pc,4=saving settings from file

extern "C" NUCLIB_API unsigned char getNUCMode();//get DCDC-NUC mode: 0=Dumb, 1=Automotive

extern "C" NUCLIB_API unsigned int  getNUCInputFlags();//get DCDC-NUC input flags
extern "C" NUCLIB_API unsigned int  getNUCOutputFlags();//get DCDC-NUC output flags
extern "C" NUCLIB_API float getNUCVIn();//get DCDC-NUC Input Voltage
extern "C" NUCLIB_API float getNUCIIn();//get DCDC-NUC Input Current
extern "C" NUCLIB_API float getNUCVOut();//get DCDC-NUC Output voltage
extern "C" NUCLIB_API float getNUCIOut();//get DCDC-NUC Output Current
extern "C" NUCLIB_API float getNUCTemperature();//get DCDC-NUC temperature - 1000 deg C is invalid value (output not enabled)
extern "C" NUCLIB_API float getNUCVIgnition();//get DCDC-NUC Ignition Voltage
extern "C" NUCLIB_API float getNUCPOut();//get DCDC-NUC Output Power
extern "C" NUCLIB_API float getNUCVThump();//get DCDC-NUC Thump Voltage

extern "C" NUCLIB_API unsigned char getNUCVerMajor();//get DCDC-NUC major version of the firmware
extern "C" NUCLIB_API unsigned char getNUCVerMinor();//get DCDC-NUC minor version of the firmware

extern "C" NUCLIB_API unsigned char getNUCDbgByte(int i);//get DCDC-NUC debug bytes

extern "C" NUCLIB_API unsigned int  getNUCTimer(unsigned int cnt);//get DCDC-NUC timer
extern "C" NUCLIB_API unsigned int  getNUCStateMachine();//get DCDC-NUC internal state machine

extern "C" NUCLIB_API void restartNUC();//restart DCDC-NUC 
extern "C" NUCLIB_API void restartNUCInBootloaderMode();//restart DCDC-NUC in bootloader mode

extern "C" NUCLIB_API void setNUCCommand1Byte(unsigned char command, unsigned char value);//DCDC-NUC direct commands (for debugging)
extern "C" NUCLIB_API void setNUCCommand2Byte(unsigned char command, unsigned int  value);//DCDC-NUC direct commands (for debugging)
extern "C" NUCLIB_API void setNUCCommandBuffer(int len, unsigned char* values);//DCDC-NUC direct commands (for debugging)

///////////////////////////////////////////////////////////////
extern "C" NUCLIB_API unsigned int getNUCMaxVariableCnt();//get DCDC-NUC maximum variable count
extern "C" NUCLIB_API unsigned char getNUCVariableData(unsigned int cnt, char* name, char* value, char* unit, char* comment);//get DCDC-NUC variable data
extern "C" NUCLIB_API void startNUCLoadingSettings(unsigned char to_file, unsigned char compare_with_old);//start loading data from device
extern "C" NUCLIB_API unsigned char getNUCLoadingSettingsState();//get load settings current state: 0-64 - steps, 100=success, 0xF1-0xFF=failure
extern "C" NUCLIB_API unsigned char setNUCVariableData(unsigned int cnt, char* value);//set DCDC-NUC variable data for a given variable 
extern "C" NUCLIB_API void startNUCSaveSettings(unsigned char from_file);//start saving data to device
extern "C" NUCLIB_API unsigned char getNUCSaveSettingsState();//get saving current state: 0-64 - steps, 100=success, 0xF1-0xFF=failure

